/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.entity.DeathChainLightning;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class NecrovoltEvent {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ItemStack weapon;
        if (!((Boolean)MajoSpellEnchantmentConfig.NecrovoltEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity dead = event.getEntity();
        if (dead.level().isClientSide()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity trueAttacker = source.getEntity();
        if (!(trueAttacker instanceof Player)) {
            return;
        }
        Player player = (Player)trueAttacker;
        if (source.getDirectEntity() instanceof DeathChainLightning) {
            return;
        }
        ItemStack itemStack = weapon = player.getMainHandItem().isEmpty() ? player.getOffhandItem() : player.getMainHandItem();
        if (weapon.isEmpty()) {
            return;
        }
        int enchantmentLevel = weapon.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.NECROVOLT_ENCHANT));
        if (enchantmentLevel <= 0) {
            return;
        }
        Level levelObj = dead.level();
        double range = MajoSpellEnchantmentConfig.getNecrovoltRadius(enchantmentLevel);
        List nearby = levelObj.getEntitiesOfClass(LivingEntity.class, dead.getBoundingBox().inflate(range), e -> e != player && e != dead && e.isAlive() && !DamageSources.isFriendlyFireBetween((Entity)e, (Entity)player));
        if (nearby.isEmpty()) {
            return;
        }
        AttributeInstance attr = player.getAttribute((Holder)AttributeRegistry.LIGHTNING_SPELL_POWER);
        double lightningPower = 0.0;
        if (attr != null) {
            lightningPower = attr.getValue();
        }
        DeathChainLightning proj = new DeathChainLightning(levelObj, (Entity)player, (Entity)dead).asDeathChain(2, (float)range, 0.0f, 10, (float)enchantmentLevel * ((Double)MajoSpellEnchantmentConfig.NecrovoltBonusDamageGrowthPerLevel.get()).floatValue());
        proj.setDamage((float)(MajoSpellEnchantmentConfig.getNecrovoltRawDamage(enchantmentLevel) + (Double)MajoSpellEnchantmentConfig.NecrovoltLightningSpellPowerScaling.get() * lightningPower));
        proj.setPos(dead.getX(), dead.getY() + (double)(dead.getBbHeight() / 2.0f), dead.getZ());
        levelObj.addFreshEntity((Entity)proj);
    }

    @SubscribeEvent
    public void onLivingDeath2(LivingDeathEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.NecrovoltEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity dead = event.getEntity();
        DamageSource src = event.getSource();
        Entity entity = src.getDirectEntity();
        if (entity instanceof DeathChainLightning) {
            DeathChainLightning lightning = (DeathChainLightning)entity;
            lightning.onKill(dead);
        }
    }
}

