/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;

public class NetherHeartEvent {
    @SubscribeEvent
    public void onModifySpellLevel(ModifySpellLevelEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.netherHeartEnabled.get()).booleanValue()) {
            return;
        }
        LivingEntity caster = event.getEntity();
        if (!(caster instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)caster;
        if (caster.level().dimension() != Level.NETHER && !caster.isOnFire()) {
            return;
        }
        AbstractSpell spell = event.getSpell();
        if (spell.getSchoolType() == SchoolRegistry.ICE.get()) {
            return;
        }
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)player);
        if (spellbook == null) {
            return;
        }
        int netherHeartLevel = spellbook.getEnchantmentLevel((Holder)Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).getOrThrow(EnchantmentRegistry.NETHER_HEART_ENCHANT));
        if (netherHeartLevel > 0) {
            event.addLevels(netherHeartLevel);
        }
    }
}

