/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public class OceanGraceEvent {
    @SubscribeEvent
    public void onSpellCast(SpellOnCastEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.oceanGraceEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!player2.isInWaterRainOrBubble()) {
            return;
        }
        ItemStack legs = player2.getItemBySlot(EquipmentSlot.LEGS);
        if (legs == null) {
            return;
        }
        HolderLookup.RegistryLookup enchants = player2.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int level = legs.getEnchantmentLevel((Holder)enchants.getOrThrow(EnchantmentRegistry.OCEAN_GRACE_ENCHANT));
        if (level <= 0) {
            return;
        }
        double reductionFactor = (Double)MajoSpellEnchantmentConfig.oceanGraceManaReductionPerLevel.get() * (double)level;
        int originalManaCost = event.getOriginalManaCost();
        int reducedCost = (int)Math.max(1.0, (double)originalManaCost * (1.0 - reductionFactor));
        event.setManaCost(reducedCost);
    }
}

