/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import com.rinko1231.majospellenchantment.init.ModMobEffects;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.time.DayOfWeek;
import java.time.LocalDate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class PartyLeaderEvent {
    @SubscribeEvent
    public void onSpellDamage(LivingDamageEvent.Post event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.partyLeaderEnabled.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!(event.getSource() instanceof SpellDamageSource)) {
            return;
        }
        HolderLookup.RegistryLookup enchants = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int enchantmentLevel = player.getMainHandItem().getEnchantmentLevel((Holder)enchants.getOrThrow(EnchantmentRegistry.PARTY_LEADER_ENCHANT));
        if (enchantmentLevel <= 0) {
            return;
        }
        LivingEntity target = event.getEntity();
        double glowChancePerLevel = (Double)MajoSpellEnchantmentConfig.partyLeaderGlowChancePerLevel.get();
        double feverChancePerLevel = (Double)MajoSpellEnchantmentConfig.partyLeaderFeverChancePerLevel.get();
        boolean glowTrigger = false;
        boolean feverTrigger = false;
        RandomSource random = player.getRandom();
        if (random.nextDouble() < glowChancePerLevel * (double)enchantmentLevel) {
            glowTrigger = true;
        }
        if (random.nextDouble() < feverChancePerLevel * (double)enchantmentLevel) {
            feverTrigger = true;
            glowTrigger = true;
        }
        if (glowTrigger) {
            target.addEffect(new MobEffectInstance(MobEffects.GLOWING, (Integer)MajoSpellEnchantmentConfig.partyLeaderEffectDuration.get() + (Integer)MajoSpellEnchantmentConfig.partyLeaderEffectDurationSundayBonus.get() * this.getSundayFlag(), 0));
        }
        if (feverTrigger) {
            target.addEffect(new MobEffectInstance(ModMobEffects.SUNDAY_FEVER, (Integer)MajoSpellEnchantmentConfig.partyLeaderEffectDuration.get() + (Integer)MajoSpellEnchantmentConfig.partyLeaderEffectDurationSundayBonus.get() * this.getSundayFlag(), 0));
        }
    }

    private int getSundayFlag() {
        DayOfWeek today = LocalDate.now().getDayOfWeek();
        return today == DayOfWeek.SUNDAY ? 1 : 0;
    }
}

