/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import com.rinko1231.majospellenchantment.init.ModMobEffects;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class PhaseDashedEvent {
    private static final Map<UUID, Integer> castCountMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastCastTimeMap = new HashMap<UUID, Long>();

    @SubscribeEvent
    public void onSpellCast(LivingDamageEvent.Post event) {
        long lastCastTime;
        if (!((Boolean)MajoSpellEnchantmentConfig.phaseDashedEnabled.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!(event.getSource() instanceof SpellDamageSource)) {
            return;
        }
        ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
        int phaseLevel = boots.getEnchantmentLevel((Holder)player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentRegistry.PHASE_DASHED_ENCHANT));
        if (phaseLevel <= 0) {
            return;
        }
        UUID playerId = player.getUUID();
        long currentTime = player.level().getGameTime();
        if (currentTime - (lastCastTime = lastCastTimeMap.getOrDefault(playerId, 0L).longValue()) > 60L) {
            castCountMap.put(playerId, 0);
        }
        int currentCount = castCountMap.getOrDefault(playerId, 0) + 1;
        castCountMap.put(playerId, currentCount);
        lastCastTimeMap.put(playerId, currentTime);
        if (currentCount >= 3) {
            castCountMap.put(playerId, 0);
            player.addEffect(new MobEffectInstance(ModMobEffects.PHASE_DASHED, ((Integer)MajoSpellEnchantmentConfig.phaseDashedEffectDuration.get()).intValue(), phaseLevel - 1, false, false, true));
        }
    }
}

