/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.entity.spells.magma_ball.FireField;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public class RedLotusEvent {
    public static final String NBT_KEY_TRIGGERED = "redlotus_triggered";

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        boolean onFire;
        if (!((Boolean)MajoSpellEnchantmentConfig.redLotusEnabled.get()).booleanValue()) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        Level level = arrow.level();
        if (level.isClientSide) {
            return;
        }
        HitResult hit = event.getRayTraceResult();
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        CompoundTag tag = arrow.getPersistentData();
        if (tag.getBoolean(NBT_KEY_TRIGGERED)) {
            return;
        }
        ItemStack weapon = arrow.getWeaponItem();
        if (weapon == null) {
            return;
        }
        if (weapon.isEmpty()) {
            return;
        }
        boolean bl = onFire = arrow.isOnFire() || arrow.getRemainingFireTicks() > 0;
        if (!onFire) {
            return;
        }
        int redLotusLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.holderLookup(EnchantmentRegistry.RED_LOTUS_ENCHANT.registryKey()).getOrThrow(EnchantmentRegistry.RED_LOTUS_ENCHANT), (ItemStack)weapon);
        if (redLotusLevel <= 0) {
            return;
        }
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.holderLookup(Enchantments.FLAME.registryKey()).getOrThrow(Enchantments.FLAME), (ItemStack)weapon);
        if (flameLevel <= 0) {
            return;
        }
        Vec3 hitPos = hit.getLocation();
        RedLotusEvent.spawnFireField((ServerLevel)level, arrow.getOwner(), hitPos, MajoSpellEnchantmentConfig.getRedLotusDuration(redLotusLevel), (float)MajoSpellEnchantmentConfig.getRedLotusRadius(redLotusLevel), MajoSpellEnchantmentConfig.getRedLotusDamage(redLotusLevel));
        tag.putBoolean(NBT_KEY_TRIGGERED, true);
    }

    private static void spawnFireField(ServerLevel level, @Nullable Entity owner, Vec3 location, int durationTicks, float radius, double damage) {
        FireField fire = new FireField((Level)level);
        fire.setOwner(owner);
        fire.setDuration(durationTicks);
        fire.setDamage((float)damage);
        fire.setRadius(radius);
        fire.setCircular();
        fire.moveTo(location);
        level.addFreshEntity((Entity)fire);
    }
}

