/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class SpellStreakEvent {
    @SubscribeEvent
    public void onMobDeath(LivingDeathEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.spellStreakEnabled.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if ((double)event.getEntity().getMaxHealth() < (Double)MajoSpellEnchantmentConfig.spellStreakEntityMinHealth.get()) {
            return;
        }
        ItemStack heldItem = serverPlayer.getMainHandItem();
        int enchantLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)serverPlayer.level().holderLookup(EnchantmentRegistry.SPELL_STREAK_ENCHANT.registryKey()).getOrThrow(EnchantmentRegistry.SPELL_STREAK_ENCHANT), (ItemStack)heldItem);
        if (enchantLevel <= 0) {
            return;
        }
        String entityIdStr = BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()).toString();
        boolean useBlacklist = (Boolean)MajoSpellEnchantmentConfig.spellStreakBlacklistOrWhitelist.get();
        if (useBlacklist ? ((List)MajoSpellEnchantmentConfig.spellStreakEntityBlacklist.get()).contains(entityIdStr) : !((List)MajoSpellEnchantmentConfig.spellStreakEntityWhitelist.get()).contains(entityIdStr)) {
            return;
        }
        double reduction = (double)enchantLevel * (Double)MajoSpellEnchantmentConfig.spellStreakCDReductionPerLevel.get();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        PlayerCooldowns cooldowns = magicData.getPlayerCooldowns();
        Map cooldownMap = cooldowns.getSpellCooldowns();
        for (Map.Entry entry : new HashMap(cooldownMap).entrySet()) {
            String spellId = (String)entry.getKey();
            CooldownInstance oldInstance = (CooldownInstance)entry.getValue();
            int remaining = oldInstance.getCooldownRemaining();
            if (remaining <= 0) continue;
            int newRemaining = (int)Math.max(0.0, (double)remaining - (double)remaining * reduction);
            CooldownInstance newInstance = new CooldownInstance(oldInstance.getSpellCooldown(), newRemaining);
            cooldownMap.put(spellId, newInstance);
        }
        cooldowns.syncToPlayer(serverPlayer);
    }
}

