/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.entity.spells.blood_needle.BloodNeedle;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class VladTepesEvent {
    @SubscribeEvent
    public void onArrowLoose(ArrowLooseEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.vladTepesEnabled.get()).booleanValue()) {
            return;
        }
        if (event.getLevel().isClientSide) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack bow = event.getBow();
        int enchantLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.level().holderLookup(EnchantmentRegistry.VLAD_TEPES_ENCHANT.registryKey()).getOrThrow(EnchantmentRegistry.VLAD_TEPES_ENCHANT), (ItemStack)bow);
        if (enchantLevel <= 0) {
            return;
        }
        AttributeInstance attr = player.getAttribute((Holder)AttributeRegistry.BLOOD_SPELL_POWER);
        double bloodPower = 0.0;
        if (attr != null) {
            bloodPower = attr.getValue();
        }
        if (player.getRandom().nextFloat() > 0.125f * (float)enchantLevel) {
            return;
        }
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
        float manaCost = (float)MajoSpellEnchantmentConfig.getVladTepesManaCost(enchantLevel);
        if (magicData.getMana() >= manaCost) {
            magicData.addMana(-manaCost);
            this.shootExtraNeedles(player, event.getLevel(), enchantLevel, bloodPower);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void shootExtraNeedles(ServerPlayer player, Level world, int enchantmentLevel, double bloodPower) {
        int count = MajoSpellEnchantmentConfig.getVladTepesBloodNeedleCount(enchantmentLevel);
        float damage = (float)(MajoSpellEnchantmentConfig.getVladTepesBloodNeedleRawDamage(enchantmentLevel) + (Double)MajoSpellEnchantmentConfig.vladTepesBloodNeedleDamageBloodSpellPowerScaling.get() * bloodPower);
        Vec3 look = player.getLookAngle();
        HitResult raycast = player.pick(64.0, 0.0f, false);
        int degreesPerNeedle = 10;
        int half = count / 2;
        for (int i = 0; i < count; ++i) {
            int offset = i - half;
            if (count % 2 == 0) {
                offset = (int)((double)offset + 0.5);
            }
            int rotation = offset * degreesPerNeedle;
            BloodNeedle needle = new BloodNeedle(world, (LivingEntity)player);
            needle.setDamage(damage);
            needle.setZRot((float)rotation);
            Vec3 spawn = player.getEyePosition().add(new Vec3(0.0, 1.5, 0.0).zRot((float)rotation * ((float)Math.PI / 180)).xRot(-player.getXRot() * ((float)Math.PI / 180)).yRot(-player.getYRot() * ((float)Math.PI / 180)));
            needle.moveTo(spawn);
            needle.shoot(raycast.getLocation().subtract(spawn).normalize());
            world.addFreshEntity((Entity)needle);
        }
    }
}

