/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.event;

import com.rinko1231.majospellenchantment.config.MajoSpellEnchantmentConfig;
import com.rinko1231.majospellenchantment.init.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class ZoophonyEvent {
    private static final List<SoundEvent> RANDOM_ANIMAL_SOUNDS = List.of(SoundEvents.CHICKEN_AMBIENT, SoundEvents.CHICKEN_HURT, SoundEvents.CHICKEN_DEATH, SoundEvents.COW_AMBIENT, SoundEvents.COW_HURT, SoundEvents.COW_DEATH, SoundEvents.PIG_DEATH, SoundEvents.SHEEP_AMBIENT, SoundEvents.SHEEP_HURT, SoundEvents.PARROT_IMITATE_GHAST, SoundEvents.LLAMA_AMBIENT, SoundEvents.LLAMA_ANGRY);

    @SubscribeEvent
    public void onSpellCast(SpellOnCastEvent event) {
        if (!((Boolean)MajoSpellEnchantmentConfig.zoophonyEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2 == null) {
            return;
        }
        int curseLevel = player2.getItemBySlot(EquipmentSlot.HEAD).getEnchantmentLevel((Holder)player2.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentRegistry.ZOOPHONY_ENCHANT));
        if (curseLevel <= 0) {
            return;
        }
        SoundEvent randomSound = RANDOM_ANIMAL_SOUNDS.get(player2.level().random.nextInt(RANDOM_ANIMAL_SOUNDS.size()));
        player2.level().playSound(null, player2.blockPosition(), randomSound, SoundSource.PLAYERS, 4.0f + (float)(curseLevel * 2), 0.8f + player2.level().random.nextFloat() * 0.4f);
    }
}

