/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.majospellenchantment.init;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;

public class EnchantmentRegistry {
    public static final ResourceKey<Enchantment> MAX_MANA_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"max_mana_enchant"));
    public static final ResourceKey<Enchantment> CD_REDUCTION_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"cd_reduction_enchant"));
    public static final ResourceKey<Enchantment> MANA_REAPER_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"mana_reaper_enchant"));
    public static final ResourceKey<Enchantment> SPELL_STREAK_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"spell_streak_enchant"));
    public static final ResourceKey<Enchantment> NETHER_HEART_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"nether_heart_enchant"));
    public static final ResourceKey<Enchantment> HOPELESS_POWER_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"hopeless_power_enchant"));
    public static final ResourceKey<Enchantment> OCEAN_GRACE_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"ocean_grace_enchant"));
    public static final ResourceKey<Enchantment> PHASE_DASHED_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"phase_dashed_enchant"));
    public static final ResourceKey<Enchantment> NOCTURNE_ARIA_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"nocturne_aria_enchant"));
    public static final ResourceKey<Enchantment> DAYLIGHT_ANTHEM_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"daylight_anthem_enchant"));
    public static final ResourceKey<Enchantment> BLOOD_MANA_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"blood_mana_enchant"));
    public static final ResourceKey<Enchantment> PARTY_LEADER_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"party_leader_enchant"));
    public static final ResourceKey<Enchantment> VLAD_TEPES_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"vlad_tepes_enchant"));
    public static final ResourceKey<Enchantment> RED_LOTUS_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"red_lotus_enchant"));
    public static final ResourceKey<Enchantment> MANA_MENDING_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"mana_mending_enchant"));
    public static final ResourceKey<Enchantment> GENTLE_GRAVEYARD_KEEPER_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"gentle_graveyard_keeper_enchant"));
    public static final ResourceKey<Enchantment> EXCITATIO_ARCANA_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"excitatio_arcana_enchant"));
    public static final ResourceKey<Enchantment> NECROVOLT_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"necrovolt_enchant"));
    public static final ResourceKey<Enchantment> ICE_FIRE_SONG_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"ice_fire_song_enchant"));
    public static final ResourceKey<Enchantment> DOMINION_HELM_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"dominion_helm_enchant"));
    public static final ResourceKey<Enchantment> POWER_IS_POWER_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"power_is_power_enchant"));
    public static final ResourceKey<Enchantment> ZOOPHONY_ENCHANT = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"zoophony_enchant"));
    public static final TagKey<Item> MANA_REAPER_COMPATIBLE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"mana_reaper_compatible"));
    public static TagKey<Item> STAFF_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"staff"));
    public static TagKey<Item> SPELLBOOK_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"spellbook"));
    public static TagKey<Item> ARCHERY_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"archery"));
    public static TagKey<Enchantment> DAY_OR_NIGHT_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"exclusive_set/dayornight"));
    public static TagKey<Enchantment> TEPES_OR_LOTUS_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"exclusive_set/tepes_or_lotus"));
    public static TagKey<Enchantment> MENDING_EXCLUSIVE_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"exclusive_set/mending_exclusive"));
    public static TagKey<Enchantment> EXCITATIO_EXCLUSIVE_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"exclusive_set/excitatio_exclusive"));
    public static TagKey<EntityType<?>> LICH_KING_TURNING_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"lich_king_turning"));

    public static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> enchantment, Enchantment.Builder builder) {
        context.register(enchantment, (Object)builder.build(enchantment.location()));
    }

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        EnchantmentRegistry.registerMaxMana(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerCD(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerReaper(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerStreak(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerNetherHeart(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerHopelessPower(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerOceanGrace(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerPhaseDashed(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerNocturneAria(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerDaylightAnthem(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerBloodMana(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerPartyLeader(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerVladTepes(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerRedLotus(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerManaMending(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerGentleGraveyardKeeper(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerExcitatioArcana(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerNecrovolt(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerIceFireSong(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerLichKing(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerZoophony(context, (HolderGetter<Item>)items);
        EnchantmentRegistry.registerPowerPower(context, (HolderGetter<Item>)items);
    }

    private static void registerMaxMana(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.HEAD_ARMOR_ENCHANTABLE), (int)8, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HEAD});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"max_mana_bonus"), (Holder)AttributeRegistry.MAX_MANA, (LevelBasedValue)LevelBasedValue.perLevel((float)40.0f, (float)40.0f), AttributeModifier.Operation.ADD_VALUE));
        EnchantmentRegistry.register(context, MAX_MANA_ENCHANT, builder);
    }

    private static void registerCD(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(MANA_REAPER_COMPATIBLE_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)6, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"cd_reduction_bonus"), (Holder)AttributeRegistry.COOLDOWN_REDUCTION, (LevelBasedValue)LevelBasedValue.perLevel((float)0.05f, (float)0.05f), AttributeModifier.Operation.ADD_VALUE));
        EnchantmentRegistry.register(context, CD_REDUCTION_ENCHANT, builder);
    }

    private static void registerReaper(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(MANA_REAPER_COMPATIBLE_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)5, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND, EquipmentSlotGroup.OFFHAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, MANA_REAPER_ENCHANT, builder);
    }

    private static void registerStreak(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(MANA_REAPER_COMPATIBLE_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)3, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, SPELL_STREAK_ENCHANT, builder);
    }

    private static void registerNetherHeart(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(SPELLBOOK_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, NETHER_HEART_ENCHANT, builder);
    }

    private static void registerHopelessPower(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.CHEST});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, HOPELESS_POWER_ENCHANT, builder);
    }

    private static void registerOceanGrace(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.LEG_ARMOR_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)8, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.LEGS});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, OCEAN_GRACE_ENCHANT, builder);
    }

    private static void registerPhaseDashed(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, PHASE_DASHED_ENCHANT, builder);
    }

    private static void registerNocturneAria(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(SPELLBOOK_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(DAY_OR_NIGHT_TAG));
        EnchantmentRegistry.register(context, NOCTURNE_ARIA_ENCHANT, builder);
    }

    private static void registerDaylightAnthem(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(SPELLBOOK_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(DAY_OR_NIGHT_TAG));
        EnchantmentRegistry.register(context, DAYLIGHT_ANTHEM_ENCHANT, builder);
    }

    private static void registerBloodMana(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)3, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.CHEST});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, BLOOD_MANA_ENCHANT, builder);
    }

    private static void registerPartyLeader(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(STAFF_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)3, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)3, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, PARTY_LEADER_ENCHANT, builder);
    }

    private static void registerVladTepes(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(ARCHERY_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, VLAD_TEPES_ENCHANT, builder);
    }

    private static void registerRedLotus(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(ARCHERY_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(TEPES_OR_LOTUS_TAG));
        EnchantmentRegistry.register(context, RED_LOTUS_ENCHANT, builder);
    }

    private static void registerManaMending(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)1, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(MENDING_EXCLUSIVE_TAG));
        EnchantmentRegistry.register(context, MANA_MENDING_ENCHANT, builder);
    }

    private static void registerGentleGraveyardKeeper(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(SPELLBOOK_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)4, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)3, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(EXCITATIO_EXCLUSIVE_TAG));
        EnchantmentRegistry.register(context, GENTLE_GRAVEYARD_KEEPER_ENCHANT, builder);
    }

    private static void registerNecrovolt(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.SWORD_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, NECROVOLT_ENCHANT, builder);
    }

    private static void registerExcitatioArcana(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(SPELLBOOK_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)4, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)3, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(EXCITATIO_EXCLUSIVE_TAG));
        EnchantmentRegistry.register(context, EXCITATIO_ARCANA_ENCHANT, builder);
    }

    private static void registerIceFireSong(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderGetter holdergetter1 = context.lookup(Registries.ENCHANTMENT);
        HolderSet.Named compatibleItems = items.getOrThrow(SPELLBOOK_TAG);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[0]);
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)holdergetter1.getOrThrow(EXCITATIO_EXCLUSIVE_TAG));
        EnchantmentRegistry.register(context, ICE_FIRE_SONG_ENCHANT, builder);
    }

    private static void registerLichKing(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.HEAD_ARMOR_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HEAD});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, DOMINION_HELM_ENCHANT, builder);
    }

    private static void registerZoophony(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        HolderSet.Named compatibleItems = items.getOrThrow(ItemTags.HEAD_ARMOR_ENCHANTABLE);
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)compatibleItems, (int)1, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HEAD});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition);
        EnchantmentRegistry.register(context, ZOOPHONY_ENCHANT, builder);
    }

    private static void registerPowerPower(BootstrapContext<Enchantment> context, HolderGetter<Item> items) {
        Enchantment.EnchantmentDefinition definition = Enchantment.definition((HolderSet)items.getOrThrow(STAFF_TAG), (int)1, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND});
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"power_power_mana_loss"), (Holder)AttributeRegistry.MAX_MANA, (LevelBasedValue)LevelBasedValue.perLevel((float)-1.0f, (float)0.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"power_power_spell_power_loss"), (Holder)AttributeRegistry.SPELL_POWER, (LevelBasedValue)LevelBasedValue.perLevel((float)-2.0f, (float)0.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"power_power_attack_damage"), Attributes.ATTACK_DAMAGE, (LevelBasedValue)LevelBasedValue.perLevel((float)7.0f, (float)0.0f), AttributeModifier.Operation.ADD_VALUE)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"power_power_armor"), Attributes.ARMOR, (LevelBasedValue)LevelBasedValue.perLevel((float)3.0f, (float)0.0f), AttributeModifier.Operation.ADD_VALUE)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"majospellenchantment", (String)"power_power_attack_speed"), Attributes.ATTACK_SPEED, (LevelBasedValue)LevelBasedValue.perLevel((float)0.8f, (float)0.0f), AttributeModifier.Operation.ADD_VALUE));
        EnchantmentRegistry.register(context, POWER_IS_POWER_ENCHANT, builder);
    }
}

