/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.morevillagers.platform.neoforge;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CommonPlatformHelperImpl {
    public static final DeferredRegister<VillagerType> VILLAGER_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_TYPE, (String)"morevillagers");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"morevillagers");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"morevillagers");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"morevillagers");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"morevillagers");

    public static Supplier<VillagerType> registerVillagerType(String name, Supplier<VillagerType> type) {
        return VILLAGER_TYPES.register(name, type);
    }

    public static <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static <T extends Item> Supplier<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static Supplier<VillagerProfession> registerProfession(String name, Supplier<VillagerProfession> profession) {
        return PROFESSIONS.register(name, profession);
    }

    public static Supplier<PoiType> registerPoiType(String name, Supplier<Set<BlockState>> matchingStates) {
        return POI_TYPES.register(name, () -> new PoiType((Set)matchingStates.get(), 1, 1));
    }

    public static boolean isModLoadedMV(String id) {
        return ModList.get().isLoaded(id);
    }
}

