/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.morevillagers.registry;

import com.frikinjay.morevillagers.mixin.GiveGiftToHeroAccessor;
import com.frikinjay.morevillagers.registry.MVProfessions;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.storage.loot.LootTable;

public class MVGifts {
    public static final ResourceKey<LootTable> OCEANOGRAPHER_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/oceanographer_gift");
    public static final ResourceKey<LootTable> NETHERIAN_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/netherian_gift");
    public static final ResourceKey<LootTable> WOODWORKER_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/woodworker_gift");
    public static final ResourceKey<LootTable> ENDERIAN_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/enderian_gift");
    public static final ResourceKey<LootTable> ENGINEER_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/engineer_gift");
    public static final ResourceKey<LootTable> FLORIST_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/florist_gift");
    public static final ResourceKey<LootTable> HUNTER_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/hunter_gift");
    public static final ResourceKey<LootTable> MINER_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/miner_gift");
    public static final ResourceKey<LootTable> ICEMAN_GIFT = MVGifts.registerGiftTable("gameplay/hero_of_the_village/iceman_gift");

    public static void init() {
    }

    public static void registerGiftMappings() {
        Map<VillagerProfession, ResourceKey<LootTable>> gifts = GiveGiftToHeroAccessor.getGifts();
        MVGifts.registerGiftsFor(gifts, MVProfessions.OCEANOGRAPHER.get(), OCEANOGRAPHER_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.NETHERIAN.get(), NETHERIAN_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.WOODWORKER.get(), WOODWORKER_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.ENDERIAN.get(), ENDERIAN_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.ENGINEER.get(), ENGINEER_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.FLORIST.get(), FLORIST_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.HUNTER.get(), HUNTER_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.MINER.get(), MINER_GIFT);
        MVGifts.registerGiftsFor(gifts, MVProfessions.ICEMAN.get(), ICEMAN_GIFT);
    }

    private static ResourceKey<LootTable> registerGiftTable(String path) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)new ResourceLocation("morevillagers", path));
    }

    private static void registerGiftsFor(Map<VillagerProfession, ResourceKey<LootTable>> gifts, VillagerProfession profession, ResourceKey<LootTable> giftTable) {
        if (profession == null) {
            return;
        }
        gifts.put(profession, giftTable);
    }
}

