/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.entity;

import earth.terrarium.pastel.registries.PastelPointOfInterestTypeTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.jetbrains.annotations.Nullable;

public interface POIMemorized {
    public static final String POI_POS_KEY = "POIPos";

    public TagKey<PoiType> getPOITag();

    @Nullable
    public BlockPos getPOIPos();

    public void setPOIPos(@Nullable BlockPos var1);

    default public void writePOIPosToNbt(CompoundTag nbt) {
        @Nullable BlockPos poiPos = this.getPOIPos();
        if (poiPos != null) {
            nbt.put(POI_POS_KEY, NbtUtils.writeBlockPos((BlockPos)poiPos));
        }
    }

    default public void readPOIPosFromNbt(CompoundTag nbt) {
        if (nbt.contains(POI_POS_KEY)) {
            this.setPOIPos(NbtUtils.readBlockPos((CompoundTag)nbt, (String)POI_POS_KEY).orElse(null));
        }
    }

    default public boolean isPOIValid(ServerLevel world) {
        @Nullable BlockPos poiPos = this.getPOIPos();
        if (poiPos == null) {
            return false;
        }
        Optional type = world.getPoiManager().getType(poiPos);
        return type.map(pointOfInterestTypeRegistryEntry -> pointOfInterestTypeRegistryEntry.is(PastelPointOfInterestTypeTags.LIZARD_DENS)).orElse(false);
    }

    @Nullable
    default public BlockPos findNearestPOI(ServerLevel world, BlockPos pos, int maxDistance) {
        PoiManager pointOfInterestStorage = world.getPoiManager();
        return pointOfInterestStorage.findClosest(poiType -> poiType.is(this.getPOITag()), pos, maxDistance, PoiManager.Occupancy.ANY).orElse(null);
    }
}

