/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction.projectile_behavior;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.interaction.projectile_behavior.ItemProjectileBehavior;
import earth.terrarium.pastel.api.interaction.projectile_behavior.ItemProjectilePlacementContext;
import earth.terrarium.pastel.api.interaction.projectile_behavior.ProjectileBehaviorType;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import earth.terrarium.pastel.registries.PastelItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public record DefaultProjectileBehavior() implements ItemProjectileBehavior
{
    public static final DefaultProjectileBehavior INSTANCE = new DefaultProjectileBehavior();
    public static final ProjectileBehaviorType<DefaultProjectileBehavior> TYPE = new ProjectileBehaviorType(PastelCommon.ofPastel("default"), MapCodec.unit((Object)INSTANCE));

    @Override
    public ItemStack onEntityHit(ItemProjectileEntity projectile, ItemStack stack, Entity owner, EntityHitResult hitResult) {
        Player player;
        Entity target = hitResult.getEntity();
        if (target instanceof Player && ((player = (Player)target).isCreative() || player.isSpectator())) {
            return stack;
        }
        if (stack.is(ItemTags.CREEPER_IGNITERS) && target instanceof Creeper) {
            Creeper creeperEntity = (Creeper)target;
            Level world = projectile.level();
            SoundEvent soundEvent = stack.is(Items.FIRE_CHARGE) ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE;
            world.playSound(null, projectile.getX(), projectile.getY(), projectile.getZ(), soundEvent, projectile.getSoundSource(), 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
            creeperEntity.ignite();
            if (stack.isDamageableItem() && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                stack.hurtAndBreak(1, serverWorld, null, item -> {});
            } else if (!stack.has(DataComponents.UNBREAKABLE)) {
                stack.shrink(1);
            }
        }
        if (target instanceof LivingEntity) {
            Player playerOwner;
            LivingEntity livingTarget = (LivingEntity)target;
            if (target instanceof Player && !PastelCommon.CONFIG.OmniAcceleratorPvP && stack.is(PastelItemTags.REQUIRES_OMNI_ACCELERATOR_PVP_ENABLED)) {
                return stack;
            }
            if (owner instanceof Player && stack.interactLivingEntity(playerOwner = (Player)owner, livingTarget, InteractionHand.MAIN_HAND).consumesAction()) {
                return stack;
            }
            stack.getItem().finishUsingItem(stack, livingTarget.level(), livingTarget);
        }
        return stack;
    }

    @Override
    public ItemStack onBlockHit(ItemProjectileEntity projectile, ItemStack stack, Entity owner, BlockHitResult hitResult) {
        Direction placementDirection;
        Level world = projectile.level();
        BlockPos hitPos = hitResult.getBlockPos();
        hitResult.withDirection(hitResult.getDirection());
        Direction facing = hitResult.getDirection().getOpposite();
        BlockPos placementPos = hitPos.relative(facing.getOpposite());
        Direction direction = placementDirection = world.isEmptyBlock(placementPos.below()) ? facing : Direction.UP;
        if (!GenericClaimModsCompat.canPlaceBlock(world, placementPos, owner)) {
            return stack;
        }
        try {
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.place((BlockPlaceContext)new ItemProjectilePlacementContext(world, projectile, hitResult));
            } else {
                stack.useOn((UseOnContext)new DirectionalPlaceContext(world, placementPos, facing, stack, placementDirection));
            }
        }
        catch (Exception e) {
            PastelCommon.logError("Item Projectile failed to use item " + String.valueOf(stack.getItem().getDescription()));
            e.printStackTrace();
        }
        return stack;
    }

    @Override
    public ProjectileBehaviorType<?> type() {
        return null;
    }
}

