/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction.projectile_behavior;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.interaction.projectile_behavior.DefaultProjectileBehavior;
import earth.terrarium.pastel.api.interaction.projectile_behavior.ProjectileBehaviorType;
import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import earth.terrarium.pastel.registries.PastelDataMaps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public interface ItemProjectileBehavior {
    public static final Map<ResourceLocation, ItemProjectileBehavior> CUSTOM_BEHAVIORS = new HashMap<ResourceLocation, ItemProjectileBehavior>();
    public static final Codec<ItemProjectileBehavior> CODEC = ResourceLocation.CODEC.xmap(CUSTOM_BEHAVIORS::get, behavior -> {
        for (Map.Entry<ResourceLocation, ItemProjectileBehavior> entry : CUSTOM_BEHAVIORS.entrySet()) {
            if (entry.getValue() != behavior) continue;
            return entry.getKey();
        }
        return PastelCommon.ofPastel("default");
    });

    public static ItemProjectileBehavior get(ItemStack stack) {
        ItemProjectileBehavior behavior = (ItemProjectileBehavior)stack.getItemHolder().getData(PastelDataMaps.PROJECTILE_BEHAVIOR);
        return behavior == null ? DefaultProjectileBehavior.INSTANCE : behavior;
    }

    public ItemStack onEntityHit(ItemProjectileEntity var1, ItemStack var2, @Nullable Entity var3, EntityHitResult var4);

    public ItemStack onBlockHit(ItemProjectileEntity var1, ItemStack var2, @Nullable Entity var3, BlockHitResult var4);

    public ProjectileBehaviorType<?> type();
}

