/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public interface AzureDikeItem {
    public int maxAzureDike(ItemStack var1);

    default public float azureDikeRechargeSpeedModifier(ItemStack stack) {
        return 1.0f;
    }

    default public float rechargeDelayAfterDamageModifier(ItemStack stack) {
        return 1.0f;
    }

    default public float maxAzureDikeMultiplier(ItemStack stack) {
        return 1.0f;
    }

    default public void recalculate(LivingEntity user) {
        Level world = user.level();
        if (!world.isClientSide) {
            AzureDikeData dikeData = AzureDikeProvider.getAzureDikeComponent(user);
            Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)user);
            if (curiosInventory.isPresent()) {
                int maxAzureDike = 0;
                float rechargeSpeedModifier = 1.0f;
                float rechargeDelayAfterDamageModifier = 1.0f;
                float maxAzureDikeMultiplier = 1.0f;
                for (SlotResult slot : ((ICuriosItemHandler)curiosInventory.get()).findCurios(stack -> stack.getItem() instanceof AzureDikeItem)) {
                    ItemStack stack2 = slot.stack();
                    AzureDikeItem azureDikeItem = (AzureDikeItem)stack2.getItem();
                    maxAzureDike += azureDikeItem.maxAzureDike(stack2);
                    rechargeSpeedModifier += azureDikeItem.azureDikeRechargeSpeedModifier(stack2) - 1.0f;
                    rechargeDelayAfterDamageModifier += azureDikeItem.rechargeDelayAfterDamageModifier(stack2) - 1.0f;
                    maxAzureDikeMultiplier += azureDikeItem.maxAzureDikeMultiplier(stack2) - 1.0f;
                }
                int ticksPerPointOfRecharge = (int)Math.max(1.0f, 40.0f / rechargeSpeedModifier);
                int rechargeDelayTicksAfterGettingHit = (int)Math.max(1.0f, 200.0f / rechargeDelayAfterDamageModifier);
                dikeData.set(Math.round((float)maxAzureDike * maxAzureDikeMultiplier), ticksPerPointOfRecharge, rechargeDelayTicksAfterGettingHit, false);
                dikeData.sync(user);
            }
        }
    }
}

