/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface InkPoweredPotionFillable {
    public int maxEffectCount();

    public int maxEffectAmplifier();

    default public long adjustFinalCostFor(@NotNull InkPoweredStatusEffectInstance instance) {
        return (long)Math.pow(instance.getInkCost().cost(), 1 + instance.getStatusEffectInstance().getAmplifier());
    }

    default public void addOrUpgradeEffects(ItemStack potionFillableStack, List<InkPoweredStatusEffectInstance> newEffects) {
        if (!this.isFull(potionFillableStack)) {
            ArrayList<InkPoweredStatusEffectInstance> existingEffects = new ArrayList<InkPoweredStatusEffectInstance>(InkPoweredStatusEffectInstance.getEffects(potionFillableStack));
            int maxCount = this.maxEffectCount();
            int maxAmplifier = this.maxEffectAmplifier();
            for (InkPoweredStatusEffectInstance newEffect : newEffects) {
                MobEffectInstance statusEffectInstance = newEffect.getStatusEffectInstance();
                if (statusEffectInstance.getAmplifier() > maxAmplifier) {
                    statusEffectInstance = new MobEffectInstance(statusEffectInstance.getEffect(), statusEffectInstance.getDuration(), maxAmplifier, statusEffectInstance.isAmbient(), statusEffectInstance.isVisible());
                }
                if (existingEffects.size() == maxCount) break;
                InkCost adjustedCost = new InkCost(newEffect.getInkCost().color(), this.adjustFinalCostFor(newEffect));
                InkPoweredStatusEffectInstance modifiedInstance = new InkPoweredStatusEffectInstance(statusEffectInstance, adjustedCost, newEffect.getColor(), newEffect.isUnidentifiable(), newEffect.isIncurable());
                existingEffects.add(modifiedInstance);
            }
            InkPoweredStatusEffectInstance.setEffects(potionFillableStack, existingEffects);
        }
    }

    public static List<InkPoweredStatusEffectInstance> getEffects(ItemStack stack) {
        return InkPoweredStatusEffectInstance.getEffects(stack);
    }

    @Deprecated
    default public List<MobEffectInstance> getVanillaEffects(ItemStack stack) {
        return InkPoweredStatusEffectInstance.getEffects(stack).stream().map(InkPoweredStatusEffectInstance::getStatusEffectInstance).toList();
    }

    default public boolean isFull(ItemStack itemStack) {
        return InkPoweredStatusEffectInstance.getEffects(itemStack).size() >= this.maxEffectCount();
    }

    default public boolean isAtLeastPartiallyFilled(ItemStack itemStack) {
        return !InkPoweredStatusEffectInstance.getEffects(itemStack).isEmpty();
    }

    default public void clearEffects(ItemStack itemStack) {
        InkPoweredStatusEffectInstance.setEffects(itemStack, List.of());
    }

    default public void appendPotionFillableTooltip(ItemStack stack, List<Component> tooltip, MutableComponent attributeModifierText, boolean showDuration, float tickRate) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredStatusEffectInstance.getEffects(stack);
        InkPoweredStatusEffectInstance.buildTooltip(tooltip, effects, attributeModifierText, showDuration, tickRate);
        int maxEffectCount = this.maxEffectCount();
        if (effects.size() < maxEffectCount) {
            if (maxEffectCount == 1) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.potion_pendant.tooltip_not_full_one"));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.potion_pendant.tooltip_not_full_count", (Object[])new Object[]{maxEffectCount}));
            }
            tooltip.add((Component)Component.translatable((String)"item.pastel.potion_pendant.tooltip_max_level").append((Component)Component.translatable((String)("enchantment.level." + (this.maxEffectAmplifier() + 1)))));
        }
    }

    default public boolean isWeapon() {
        return false;
    }
}

