/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import earth.terrarium.pastel.capabilities.PastelCapabilities;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public interface ItemPickupListener {
    public boolean accepts(Optional<ItemStack> var1, ItemStack var2);

    public ItemStack receive(Optional<ItemStack> var1, ItemStack var2, Optional<Entity> var3);

    public static ItemStack receiveRecursive(IItemHandler inventory, int depthLimit, int depth, ItemStack stack, Optional<Entity> taker) {
        int tries = Math.min(inventory.getSlots(), 128);
        for (int slot = 0; slot < tries; ++slot) {
            IItemHandler depthInv;
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack proposal = inventory.getStackInSlot(slot);
            ItemPickupListener receiver = (ItemPickupListener)proposal.getCapability(PastelCapabilities.Pickup.ITEM);
            Optional<ItemStack> prop = Optional.of(proposal);
            if (receiver != null && receiver.accepts(prop, stack) && inventory instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable mod = (IItemHandlerModifiable)inventory;
                stack = receiver.receive(prop, stack, taker);
                mod.setStackInSlot(slot, proposal);
                continue;
            }
            if (depth == depthLimit || (depthInv = (IItemHandler)proposal.getCapability(Capabilities.ItemHandler.ITEM)) == null) continue;
            stack = ItemPickupListener.receiveRecursive(depthInv, depthLimit, depth + 1, stack, taker);
        }
        return stack;
    }
}

