/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class ItemReference
implements ItemLike,
DataComponentHolder {
    private static final ItemReference EMPTY = ItemReference.of((ItemLike)Items.AIR);
    public static final Codec<ItemReference> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("reference").forGetter(ref -> ref.reference), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(ref -> ref.components.asPatch())).apply((Applicative)i, ItemReference::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemReference> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemReference>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Item> ITEM_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.ITEM);

        public ItemReference decode(RegistryFriendlyByteBuf buf) {
            Item reference = (Item)ITEM_CODEC.decode((Object)buf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
            return new ItemReference(reference, datacomponentpatch);
        }

        public void encode(RegistryFriendlyByteBuf buf, ItemReference itemReference) {
            ITEM_CODEC.encode((Object)buf, (Object)itemReference.reference);
            DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)itemReference.components.asPatch());
        }
    };
    public final Item reference;
    private final PatchedDataComponentMap components;

    private ItemReference(Item reference) {
        this.reference = reference;
        this.components = new PatchedDataComponentMap(reference.components());
    }

    private ItemReference(Item reference, DataComponentPatch components) {
        this.reference = reference;
        this.components = PatchedDataComponentMap.fromPatch((DataComponentMap)reference.components(), (DataComponentPatch)components);
    }

    public static ItemReference of(ItemLike reference) {
        return new ItemReference(reference.asItem());
    }

    public static ItemReference of(ItemStack stack) {
        if (stack.isEmpty()) {
            return new ItemReference(Items.AIR, stack.getComponentsPatch());
        }
        return new ItemReference(stack.getItem(), stack.getComponentsPatch());
    }

    public boolean permits(ItemStack stack) {
        if (this.isEmpty() && stack.isEmpty()) {
            return true;
        }
        return stack.is(this.reference) && this.components.equals((Object)stack.getComponents());
    }

    public ItemReference swap(Item item) {
        return new ItemReference(item);
    }

    public boolean is(ItemLike item) {
        return this.reference == item.asItem();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemReference)) {
            return false;
        }
        ItemReference other = (ItemReference)obj;
        if (this == other) {
            return true;
        }
        return this.reference == other.reference && this.components.equals((Object)other.components);
    }

    public int hashCode() {
        return Objects.hash(this.reference, this.components);
    }

    public Item asItem() {
        return this.reference;
    }

    public ItemStack asStack() {
        ItemStack stack = this.reference.getDefaultInstance();
        stack.applyComponents((DataComponentMap)this.components);
        return stack;
    }

    public ItemStack asStack(int count) {
        return this.asStack().copyWithCount(count);
    }

    public static ItemReference empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.reference.asItem().equals(Items.AIR);
    }

    public DataComponentMap getComponents() {
        return this.components;
    }

    public DataComponentPatch asPatch() {
        return this.components.asPatch();
    }
}

