/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.Iterator;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStorage {
    public static final Codec<ItemStorage> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemReference.CODEC.fieldOf("reference").forGetter(ItemStorage::getReference), (App)Codec.LONG.fieldOf("count").forGetter(ItemStorage::getCount), (App)Codec.LONG.optionalFieldOf("limit", (Object)-1L).forGetter(ItemStorage::getLimit)).apply((Applicative)i, ItemStorage::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStorage> STREAM_CODEC = StreamCodec.composite(ItemReference.STREAM_CODEC, ItemStorage::getReference, (StreamCodec)ByteBufCodecs.VAR_LONG, ItemStorage::getCount, (StreamCodec)ByteBufCodecs.VAR_LONG, ItemStorage::getLimit, ItemStorage::new);
    private ItemReference reference;
    private long count;
    private long limit = -1L;

    public ItemStorage(ItemReference reference, long count, long limit) {
        this(reference, count);
        this.limit = limit;
    }

    public ItemStorage(ItemReference reference, long count) {
        this.reference = reference;
        this.count = count;
    }

    public ItemStorage(ItemReference reference) {
        this(reference, 0L);
    }

    public static ItemStorage blank() {
        return new ItemStorage(ItemReference.empty(), 0L);
    }

    public static ItemStorage limited(long limit) {
        ItemStorage storage = ItemStorage.blank();
        storage.setLimit(limit);
        return storage;
    }

    public long getCount() {
        return this.count;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public ItemReference getReference() {
        return this.reference;
    }

    public int stackSize() {
        return this.reference.asItem().getMaxStackSize(this.stack(1));
    }

    public void increment(long increment) {
        this.count = this.isLimited() ? Math.min(this.limit, this.count + increment) : (this.count += increment);
    }

    public int insert(ItemStack stack) {
        if (this.isEmpty()) {
            this.reference = ItemReference.of(stack);
        }
        int offer = stack.getCount();
        if (!this.reference.permits(stack)) {
            return 0;
        }
        long old = this.count;
        this.increment(offer);
        return (int)(this.count - old);
    }

    public ItemStack extract(long extract) {
        return this.stack((int)this.extractPure(extract));
    }

    public long extractPure(long extract) {
        if (extract == 0L || this.count == 0L) {
            return 0L;
        }
        long decrement = Math.min(this.count, extract);
        this.increment(-decrement);
        return decrement;
    }

    public void setCount(long count) {
        if (count < 0L) {
            count = 0L;
        }
        this.count = count;
    }

    public void setReference(ItemReference reference) {
        this.reference = reference;
    }

    public ItemStorage copy() {
        return new ItemStorage(this.reference, this.count, this.limit);
    }

    public ItemStack stack(int count) {
        if (count == 0) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((Holder)this.reference.asItem().builtInRegistryHolder(), count, this.reference.asPatch());
    }

    public ItemStack unsafeStack() {
        return this.stack((int)this.count);
    }

    public boolean isLimited() {
        return this.limit >= 0L;
    }

    public boolean isEmpty() {
        return this.count == 0L;
    }

    public static ItemStorage load(ItemStack holder) {
        Component component = (Component)holder.getOrDefault(PastelDataComponentTypes.ITEM_STORAGE, (Object)Component.DEFAULT);
        ItemStorage storage = new ItemStorage(component.reference, component.count);
        Item item = holder.getItem();
        if (item instanceof LimitCallback) {
            LimitCallback callback = (LimitCallback)item;
            storage.setLimit(callback.updateLimit(holder));
        }
        return storage;
    }

    public void save(ItemStack holder) {
        this.save(holder, true);
    }

    public void save(ItemStack holder, boolean blankOnEmpty) {
        if (blankOnEmpty && this.isEmpty() && !this.reference.isEmpty()) {
            this.setReference(ItemReference.empty());
        }
        holder.set(PastelDataComponentTypes.ITEM_STORAGE, (Object)new Component(this.reference, this.count));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemStorage)) {
            return false;
        }
        ItemStorage other = (ItemStorage)obj;
        if (this == other) {
            return true;
        }
        return this.count == other.count && this.reference.equals(other.reference);
    }

    public int hashCode() {
        return 31 * (31 + this.reference.asItem().hashCode() + this.reference.getComponents().hashCode());
    }

    public record Component(ItemReference reference, long count) {
        public static final Component DEFAULT = new Component(ItemReference.empty(), 0L);
        public static final Codec<Component> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemReference.CODEC.fieldOf("reference").forGetter(Component::reference), (App)Codec.LONG.fieldOf("count").forGetter(Component::count)).apply((Applicative)i, Component::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = StreamCodec.composite(ItemReference.STREAM_CODEC, Component::reference, (StreamCodec)ByteBufCodecs.VAR_LONG, Component::count, Component::new);
    }

    public static interface LimitCallback {
        public long updateLimit(ItemStack var1);
    }

    public static class IterableView
    implements Iterator<ItemStack> {
        private final ItemStorage storage;

        public IterableView(ItemStorage storage) {
            this.storage = storage;
        }

        @Override
        public boolean hasNext() {
            return !this.storage.isEmpty();
        }

        @Override
        public ItemStack next() {
            return this.storage.extract(this.storage.stackSize());
        }
    }
}

