/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;

public interface Preenchanted {
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments();

    public static ItemEnchantments buildDefaultEnchantments(HolderLookup.Provider lookup, Preenchanted item) {
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Map.Entry<ResourceKey<Enchantment>, Integer> entry : item.getDefaultEnchantments().entrySet()) {
            builder.set((Holder)lookup.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(entry.getKey()), entry.getValue().intValue());
        }
        return builder.toImmutable();
    }

    @NotNull
    public static <T extends Item> ItemStack getDefaultEnchantedStack(HolderLookup.Provider lookup, T item) {
        ItemStack stack = new ItemStack(item);
        stack.set(DataComponents.ENCHANTMENTS, (Object)Preenchanted.buildDefaultEnchantments(lookup, (Preenchanted)item));
        return stack;
    }

    default public boolean onlyHasPreEnchantments(ItemStack stack) {
        ItemEnchantments currentEnchants = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        Map<ResourceKey<Enchantment>, Integer> defaultEnchants = this.getDefaultEnchantments();
        return currentEnchants.equals(defaultEnchants);
    }
}

