/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.pastel;

import earth.terrarium.pastel.api.pastel.PastelUpgradeable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public final class PastelUpgradeSignature {
    public static final String INNER_RING_BASE_PATH = "textures/block/pastel_node_inner_ring_";
    public static final String OUTER_RING_BASE_PATH = "textures/block/pastel_node_outer_ring_";
    public static final String REDSTONE_RING_BASE_PATH = "textures/block/pastel_node_redstone_ring_";
    public final Item upgradeItem;
    public final String name;
    public final ResourceLocation outerRing;
    public final ResourceLocation innerRing;
    public final int stack;
    public final int speed;
    public final int slotRows;
    public final float stackMult;
    public final float speedMult;
    public final boolean light;
    public final boolean priority;
    public final boolean triggerTransfer;
    public final boolean lamp;
    public final boolean sensor;
    public final Category category;
    public final RedstoneStateModifier preProcessor;
    public final RedstoneStateModifier postProcessor;

    private PastelUpgradeSignature(Item upgradeItem, String name, ResourceLocation outerRing, ResourceLocation innerRing, int stack, int speed, int slotRows, float stackMult, float speedMult, boolean light, boolean priority, boolean triggerTransfer, boolean lamp, boolean sensor, Category category, RedstoneStateModifier preProcessor, RedstoneStateModifier postProcessor) {
        this.upgradeItem = upgradeItem;
        this.name = name;
        this.outerRing = outerRing;
        this.innerRing = innerRing;
        this.stack = stack;
        this.speed = speed;
        this.slotRows = slotRows;
        this.stackMult = stackMult;
        this.speedMult = speedMult;
        this.light = light;
        this.priority = priority;
        this.triggerTransfer = triggerTransfer;
        this.lamp = lamp;
        this.category = category;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.sensor = sensor;
    }

    public ResourceLocation outerRing() {
        return this.outerRing;
    }

    public ResourceLocation innerRing() {
        return this.innerRing;
    }

    public static Builder builder(Item upgradeItem, Category category, String namespace) {
        return new Builder(upgradeItem, category, namespace);
    }

    public static abstract class Category {
        public abstract boolean compoundsWith(Category var1);

        public static Category simple() {
            return new Category(){

                @Override
                public boolean compoundsWith(Category other) {
                    return other == this;
                }
            };
        }

        public static Category nonCompounding() {
            return new Category(){

                @Override
                public boolean compoundsWith(Category other) {
                    return false;
                }
            };
        }

        public static Category redstone() {
            return new Category(){

                @Override
                public boolean compoundsWith(Category other) {
                    return false;
                }

                @Override
                public boolean isRedstone() {
                    return true;
                }
            };
        }

        public boolean isRedstone() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface RedstoneStateModifier {
        public static final RedstoneStateModifier PASS = context -> InteractionResult.PASS;

        public InteractionResult apply(RedstoneContext var1);
    }

    public static final class Builder {
        private final Item upgradeItem;
        private final Category category;
        private final String namespace;
        private String name;
        private String outerRing;
        private String innerRing;
        private int stackMod;
        private int speedMod;
        private int slotRowMod;
        private float stackMult = 1.0f;
        private float speedMult = 1.0f;
        private boolean light;
        private boolean priority;
        private boolean triggerTransfer;
        private boolean lamp;
        private boolean sensor;
        private RedstoneStateModifier preProcessor = RedstoneStateModifier.PASS;
        private RedstoneStateModifier postProcessor = RedstoneStateModifier.PASS;

        public Builder(Item upgradeItem, Category category, String namespace) {
            this.upgradeItem = upgradeItem;
            this.category = category;
            this.namespace = namespace;
        }

        public Builder named(String name) {
            this.name(name);
            this.outerRing(name);
            this.innerRing(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder outerRing(String name) {
            this.outerRing = PastelUpgradeSignature.OUTER_RING_BASE_PATH + name + ".png";
            return this;
        }

        public Builder innerRing(String name) {
            this.innerRing = PastelUpgradeSignature.INNER_RING_BASE_PATH + name + ".png";
            return this;
        }

        public Builder redstone(String name) {
            this.name(name);
            this.outerRing = PastelUpgradeSignature.REDSTONE_RING_BASE_PATH + name + ".png";
            return this;
        }

        public Builder stackMod(int stackMod) {
            this.stackMod = stackMod;
            return this;
        }

        public Builder speedMod(int speedMod) {
            this.speedMod = speedMod;
            return this;
        }

        public Builder slotRowMod(int slotRowMod) {
            this.slotRowMod = slotRowMod;
            return this;
        }

        public Builder stackMult(float stackMult) {
            this.stackMult = stackMult;
            return this;
        }

        public Builder speedMult(float speedMult) {
            this.speedMult = speedMult;
            return this;
        }

        public Builder light(boolean light) {
            this.light = light;
            return this;
        }

        public Builder priority(boolean priority) {
            this.priority = priority;
            return this;
        }

        public Builder triggerTransfer(boolean triggerTransfer) {
            this.triggerTransfer = triggerTransfer;
            return this;
        }

        public Builder lamp(boolean lamp) {
            this.lamp = lamp;
            return this;
        }

        public Builder sensor(boolean sensor) {
            this.sensor = sensor;
            return this;
        }

        public Builder redstonePreProcess(RedstoneStateModifier modifier) {
            this.preProcessor = modifier;
            return this;
        }

        public Builder redstonePostProcess(RedstoneStateModifier modifier) {
            this.postProcessor = modifier;
            return this;
        }

        public PastelUpgradeSignature build() {
            this.verify();
            return new PastelUpgradeSignature(this.upgradeItem, this.name, ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.outerRing), ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.innerRing), this.stackMod, this.speedMod, this.slotRowMod, this.stackMult, this.speedMult, this.light, this.priority, this.triggerTransfer, this.lamp, this.sensor, this.category, this.preProcessor, this.postProcessor);
        }

        public PastelUpgradeSignature buildRedstone() {
            this.verify();
            return new PastelUpgradeSignature(this.upgradeItem, this.name, ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.outerRing), null, 0, 0, 0, 0.0f, 0.0f, false, false, this.triggerTransfer, this.lamp, this.sensor, this.category, this.preProcessor, this.postProcessor);
        }

        private void verify() {
            if (this.name == null) {
                throw new IllegalStateException("Name can't be null");
            }
            if (this.outerRing == null) {
                throw new IllegalStateException("Main path can't be null");
            }
        }
    }

    public record RedstoneContext(PastelUpgradeable upgradeable, Level world, BlockPos pos, boolean active) {
    }
}

