/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.predicate.location;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;

public enum WeatherPredicate implements StringRepresentable
{
    CLEAR_SKY(world -> !world.isRaining()),
    RAIN(Level::isRaining),
    STRICT_RAIN(world -> world.isRaining() && !world.isThundering()),
    THUNDER(Level::isThundering),
    NOT_THUNDER(world -> !world.isThundering());

    public static final Codec<WeatherPredicate> CODEC;
    public static final StreamCodec<ByteBuf, WeatherPredicate> STREAM_CODEC;
    private final Function<ServerLevel, Boolean> test;

    private WeatherPredicate(Function<ServerLevel, Boolean> test) {
        this.test = test;
    }

    public boolean test(ServerLevel world) {
        return this.test.apply(world);
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromEnum(WeatherPredicate::values);
        STREAM_CODEC = PacketCodecHelper.enumOf(WeatherPredicate::values);
    }
}

