/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.predicate.location;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.predicate.location.CommandPredicate;
import earth.terrarium.pastel.api.predicate.location.MoonPhasePredicate;
import earth.terrarium.pastel.api.predicate.location.TimeOfDayPredicate;
import earth.terrarium.pastel.api.predicate.location.WeatherPredicate;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public record WorldConditionsPredicate(Optional<MoonPhasePredicate> moonPhase, Optional<TimeOfDayPredicate> timeOfDay, Optional<WeatherPredicate> weather, Optional<CommandPredicate> command, LocationPredicate location) {
    public static final Codec<WorldConditionsPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MoonPhasePredicate.CODEC.optionalFieldOf("moon_phase").forGetter(p -> p.moonPhase), (App)TimeOfDayPredicate.CODEC.optionalFieldOf("time_of_day").forGetter(p -> p.timeOfDay), (App)WeatherPredicate.CODEC.optionalFieldOf("weather").forGetter(p -> p.weather), (App)CommandPredicate.CODEC.optionalFieldOf("command").forGetter(p -> p.command), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(p -> p.location.biomes()), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structures").forGetter(p -> p.location.structures()), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).optionalFieldOf("dimension").forGetter(p -> p.location.dimension()), (App)LightPredicate.CODEC.optionalFieldOf("light").forGetter(p -> p.location.light()), (App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(p -> p.location.block()), (App)FluidPredicate.CODEC.optionalFieldOf("fluid").forGetter(p -> p.location.fluid()), (App)Codec.BOOL.optionalFieldOf("smokey").forGetter(p -> p.location.smokey()), (App)Codec.BOOL.optionalFieldOf("can_see_sky").forGetter(p -> p.location.canSeeSky())).apply((Applicative)instance, WorldConditionsPredicate::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WorldConditionsPredicate> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.optional(MoonPhasePredicate.STREAM_CODEC), p -> p.moonPhase, ByteBufCodecs.optional(TimeOfDayPredicate.STREAM_CODEC), p -> p.timeOfDay, ByteBufCodecs.optional(WeatherPredicate.STREAM_CODEC), p -> p.weather, ByteBufCodecs.optional(CommandPredicate.STREAM_CODEC), p -> p.command, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME)), p -> p.location.biomes(), ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.STRUCTURE)), p -> p.location.structures(), ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION)), p -> p.location.dimension(), ByteBufCodecs.optional(PacketCodecHelper.LIGHT_PREDICATE), p -> p.location.light(), ByteBufCodecs.optional((StreamCodec)BlockPredicate.STREAM_CODEC), p -> p.location.block(), ByteBufCodecs.optional(PacketCodecHelper.FLUID_PREDICATE), p -> p.location.fluid(), ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), p -> p.location.smokey(), ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), p -> p.location.canSeeSky(), WorldConditionsPredicate::new);

    public WorldConditionsPredicate(Optional<MoonPhasePredicate> moonPhase, Optional<TimeOfDayPredicate> timeOfDay, Optional<WeatherPredicate> weather, Optional<CommandPredicate> command, Optional<HolderSet<Biome>> biomes, Optional<HolderSet<Structure>> structures, Optional<ResourceKey<Level>> dimension, Optional<LightPredicate> light, Optional<BlockPredicate> block, Optional<FluidPredicate> fluid, Optional<Boolean> smokey, Optional<Boolean> canSeeSky) {
        this(moonPhase, timeOfDay, weather, command, new LocationPredicate(Optional.empty(), biomes, structures, dimension, smokey, light, block, fluid, canSeeSky));
    }

    public boolean test(ServerLevel world, BlockPos pos) {
        return this.location.matches(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) && this.moonPhase.map(p -> p.test(world)).orElse(true) != false && this.timeOfDay.map(p -> p.test(world)).orElse(true) != false && this.weather.map(p -> p.test(world)).orElse(true) != false && this.command.map(p -> p.test(world, pos)).orElse(true) != false;
    }
}

