/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class IngredientStack
implements ICustomIngredient {
    public static final MapCodec<IngredientStack> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MapCodec.assumeMapUnsafe((Codec)Ingredient.CODEC_NONEMPTY).forGetter(IngredientStack::getIngredient), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(o -> o.componentPredicate), (App)DataComponentPatch.CODEC.optionalFieldOf("preview_components", (Object)DataComponentPatch.EMPTY).forGetter(o -> o.previewComponents), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(o -> o.count)).apply((Applicative)i, IngredientStack::new));
    public static final Codec<IngredientStack> CODEC = Codec.withAlternative((Codec)MAP_CODEC.codec(), (Codec)Codec.xor((Codec)BuiltInRegistries.ITEM.byNameCodec(), (Codec)TagKey.hashedCodec((ResourceKey)Registries.ITEM)).xmap(either -> (IngredientStack)either.map(IngredientStack::ofItems, IngredientStack::ofTag), ingredientStack -> ingredientStack.item != null ? Either.left((Object)ingredientStack.item) : Either.right(ingredientStack.tag)));
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientStack> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, o -> o.ingredient, (StreamCodec)DataComponentPredicate.STREAM_CODEC, o -> o.componentPredicate, (StreamCodec)DataComponentPatch.STREAM_CODEC, o -> o.previewComponents, (StreamCodec)ByteBufCodecs.VAR_INT, o -> o.count, IngredientStack::new);
    public static final IngredientType<IngredientStack> TYPE = new IngredientType(MAP_CODEC, STREAM_CODEC);
    private final Ingredient ingredient;
    private final DataComponentPredicate componentPredicate;
    private final DataComponentPatch previewComponents;
    private final int count;
    private Item item = null;
    private TagKey<Item> tag = null;
    public static final IngredientStack EMPTY = new IngredientStack(Ingredient.EMPTY, DataComponentPredicate.EMPTY, DataComponentPatch.EMPTY, 0);

    public IngredientStack(Ingredient ingredient, DataComponentPredicate componentPredicate, DataComponentPatch previewComponents, int count) {
        this.ingredient = ingredient;
        this.componentPredicate = componentPredicate;
        this.previewComponents = previewComponents;
        this.count = count;
    }

    private IngredientStack(Ingredient ingredient) {
        this(ingredient, DataComponentPredicate.EMPTY, DataComponentPatch.EMPTY, 1);
    }

    public int getCount() {
        return this.count;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static IngredientStack of(Ingredient ingredient) {
        return new IngredientStack(ingredient);
    }

    public static IngredientStack ofItems(Item item) {
        return new IngredientStack(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static IngredientStack ofItems(Item item, int count) {
        IngredientStack ingredientStack = new IngredientStack(Ingredient.of((ItemLike[])new ItemLike[]{item}), DataComponentPredicate.EMPTY, DataComponentPatch.EMPTY, count);
        ingredientStack.item = item;
        return ingredientStack;
    }

    public static IngredientStack ofTag(TagKey<Item> tag) {
        return new IngredientStack(Ingredient.of(tag));
    }

    public static IngredientStack ofTag(TagKey<Item> tag, int count) {
        IngredientStack ingredientStack = new IngredientStack(Ingredient.of(tag), DataComponentPredicate.EMPTY, DataComponentPatch.EMPTY, count);
        ingredientStack.tag = tag;
        return ingredientStack;
    }

    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack) && this.count <= itemStack.getCount() && this.componentPredicate.test(itemStack.getComponents());
    }

    public Stream<ItemStack> getItems() {
        ItemStack[] matchingStacks = this.ingredient.getItems();
        return Arrays.stream(matchingStacks).map(stack -> {
            ItemStack itemStack = new ItemStack((ItemLike)stack.getItem(), this.count);
            itemStack.applyComponentsAndValidate(this.previewComponents);
            return itemStack;
        });
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.ingredient.isEmpty();
    }

    public IngredientType<?> getType() {
        return TYPE;
    }

    public static void register(IEventBus modEventBus) {
        DeferredRegister register = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"pastel");
        register.register("ingredient_stack", () -> TYPE);
        register.register(modEventBus);
    }
}

