/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import earth.terrarium.pastel.deeper_down.Environmental;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.items.trinkets.PriscillentSpectaclesItem;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SpectacleData {
    public static final AttachmentType<SpectacleData> ATTACHMENT = AttachmentType.builder(h -> new SpectacleData((Player)h)).build();
    public static final InkCost INK_COST = new InkCost(InkColors.LIGHT_BLUE, 20L);
    public static final ItemStack ITEM_COST = new ItemStack((ItemLike)Items.GLOW_INK_SAC, 1);
    private final Player holder;
    private long duration;
    private float potency;
    private boolean active;
    private boolean sessionStart = true;

    public SpectacleData(Player holder) {
        this.holder = holder;
    }

    public static void tickClient(Player holder) {
        SpectacleData data = (SpectacleData)holder.getData(ATTACHMENT);
        if (data.active && data.potency < 0.8f) {
            data.potency += 0.02f;
        } else if (!data.active && data.potency > 0.0f) {
            data.potency -= 0.04f;
        }
        if (data.duration > 0L && SpectacleData.isActive(holder)) {
            --data.duration;
        }
    }

    public void tickServer() {
        Level level;
        boolean activate;
        if (this.sessionStart) {
            this.sessionStart = false;
            this.sync();
        }
        boolean bl = activate = (level = this.holder.level()).getMaxLocalRawBrightness(this.holder.blockPosition()) < 8 || level.dimension().equals(PastelLevels.DIMENSION_KEY);
        if (!this.updateDuration()) {
            activate = false;
        }
        if (activate == this.active) {
            return;
        }
        this.active = activate;
        this.sync();
    }

    private boolean updateDuration() {
        if (this.duration > 0L) {
            if (this.active) {
                --this.duration;
            }
            return true;
        }
        boolean paid = this.holder.isCreative();
        if (!paid) {
            boolean bl = paid = InkPowered.tryDrainEnergy(this.holder, INK_COST) || InventoryHelper.removeFromInventoryWithRemainders(this.holder, ITEM_COST);
        }
        if (!paid) {
            return false;
        }
        this.duration = (long)PastelCommon.CONFIG.GlowVisionGogglesDuration * 20L;
        this.holder.level().playSound(null, (Entity)this.holder, PastelSounds.ITEM_ARMOR_EQUIP_GLOW_VISION, SoundSource.PLAYERS, 0.2f, 1.0f);
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public static boolean isActive(Player player) {
        return ((SpectacleData)player.getData(SpectacleData.ATTACHMENT)).potency > 0.0f && PriscillentSpectaclesItem.hasEquipped((LivingEntity)player, (Item)PastelItems.PRISCILLENT_SPECTACLES.get());
    }

    public float getPotency() {
        float finalPot = Math.clamp(this.potency - 0.15f, 0.0f, 0.5f);
        if (Environmental.isActive().force()) {
            finalPot /= 3.0f;
        }
        return finalPot *= 1.0f - Environmental.getEnvData().darkening();
    }

    public float getRemainingDuration() {
        return (float)this.duration / (float)((long)PastelCommon.CONFIG.GlowVisionGogglesDuration * 20L);
    }

    public void sync() {
        AttachmentUtil.syncToPlayer(new Payload(this.duration, this.active), this.holder);
    }

    public record Payload(long duration, boolean active) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, Payload::duration, (StreamCodec)ByteBufCodecs.BOOL, Payload::active, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("spectacle");

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void execute(Payload payload, IPayloadContext context) {
            SpectacleData data = (SpectacleData)context.player().getData(ATTACHMENT);
            data.duration = payload.duration();
            data.active = payload.active();
        }
    }
}

