/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DeeperDownPortalBlock
extends Block {
    public static final MapCodec<DeeperDownPortalBlock> CODEC = DeeperDownPortalBlock.simpleCodec(DeeperDownPortalBlock::new);
    private static final ResourceLocation CREATE_PORTAL_ADVANCEMENT_IDENTIFIER = PastelCommon.locate("midgame/open_deeper_down_portal");
    private static final String CREATE_PORTAL_ADVANCEMENT_CRITERION = "opened_deeper_down_portal";
    public static final BooleanProperty FACING_UP = BlockStateProperties.UP;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DeeperDownPortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends DeeperDownPortalBlock> codec() {
        return CODEC;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        if (!world.isClientSide) {
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, Vec3.atCenterOf((Vec3i)pos), (ParticleOptions)PastelParticleTypes.VOID_FOG, 30, new Vec3(0.5, 0.0, 0.5), Vec3.ZERO);
            if (!this.hasNeighboringPortals(world, pos)) {
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PastelSounds.DEEPER_DOWN_PORTAL_OPEN, SoundSource.BLOCKS, 0.75f, 0.75f);
                for (Player nearbyPlayer : world.getEntities((EntityTypeTest)EntityType.PLAYER, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)16.0, (double)16.0, (double)16.0), LivingEntity::isAlive)) {
                    Support.grantAdvancementCriterion((ServerPlayer)nearbyPlayer, CREATE_PORTAL_ADVANCEMENT_IDENTIFIER, CREATE_PORTAL_ADVANCEMENT_CRITERION);
                }
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (handStack.is((Item)PastelItems.BEDROCK_DUST.get())) {
            if (world.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockState placedState = Blocks.BEDROCK.defaultBlockState();
            world.setBlockAndUpdate(pos, placedState);
            world.playSound(null, pos, placedState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean hasNeighboringPortals(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!world.getBlockState(pos.relative(direction)).is((Block)this)) continue;
            return true;
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)FACING_UP) != false ? SHAPE_UP : SHAPE;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING_UP});
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (entity.canUsePortal(false) && !entity.isOnPortalCooldown()) {
                ServerLevel targetWorld;
                entity.setPortalCooldown();
                ResourceKey currentWorldKey = world.dimension();
                if (currentWorldKey == Level.NETHER) {
                    boolean facingUp = (Boolean)state.getValue((Property)FACING_UP);
                    if (facingUp) {
                        BlockPos portalPos = new BlockPos(pos.getX(), world.getMinBuildHeight(), pos.getZ());
                        if (!world.getBlockState(portalPos).is((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get())) {
                            world.setBlockAndUpdate(portalPos, (BlockState)((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get()).defaultBlockState().setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false)));
                        }
                        if (entity instanceof Player) {
                            this.makeRoomAround(world, portalPos, 4, 2, true, (TagKey<Block>)BlockTags.BASE_STONE_NETHER);
                        }
                        BlockPos targetPos = portalPos.above(2);
                        entity.changeDimension(new DimensionTransition(serverWorld, Vec3.atCenterOf((Vec3i)targetPos), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                        this.teleportToSafePosition((Level)serverWorld, entity, targetPos, 3);
                    } else {
                        BlockPos portalPos = new BlockPos(pos.getX(), world.getMinBuildHeight() + world.dimensionType().logicalHeight() - 1, pos.getZ());
                        if (!world.getBlockState(portalPos).is((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get())) {
                            world.setBlockAndUpdate(portalPos, (BlockState)((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get()).defaultBlockState().setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(true)));
                        }
                        if (entity instanceof Player) {
                            this.makeRoomAround(world, portalPos, 4, 2, false, (TagKey<Block>)BlockTags.BASE_STONE_NETHER);
                        }
                        BlockPos targetPos = portalPos.below(3);
                        entity.changeDimension(new DimensionTransition(serverWorld, Vec3.atCenterOf((Vec3i)targetPos), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING));
                        this.teleportToSafePosition((Level)serverWorld, entity, targetPos.below(), 5);
                    }
                    return;
                }
                if (currentWorldKey == Level.OVERWORLD && (targetWorld = serverWorld.getServer().getLevel(PastelLevels.DIMENSION_KEY)) != null) {
                    BlockPos portalPos = new BlockPos(pos.getX(), targetWorld.getMaxBuildHeight() - 1, pos.getZ());
                    if (!targetWorld.getBlockState(portalPos).is((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get())) {
                        targetWorld.setBlockAndUpdate(portalPos, (BlockState)((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get()).defaultBlockState().setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(true)));
                    }
                    if (entity instanceof Player) {
                        this.makeRoomAround((Level)targetWorld, portalPos, 4, 2, false, PastelBlockTags.BASE_STONE_DEEPER_DOWN);
                    }
                    BlockPos targetPos = portalPos.below(3);
                    entity.changeDimension(new DimensionTransition(targetWorld, Vec3.atCenterOf((Vec3i)targetPos), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET)));
                    this.teleportToSafePosition((Level)targetWorld, entity, targetPos.below(), 5);
                    return;
                }
                targetWorld = serverWorld.getServer().getLevel(Level.OVERWORLD);
                if (targetWorld != null) {
                    BlockPos portalPos = new BlockPos(pos.getX(), targetWorld.getMinBuildHeight(), pos.getZ());
                    if (!targetWorld.getBlockState(portalPos).is((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get())) {
                        targetWorld.setBlockAndUpdate(portalPos, (BlockState)((Block)PastelBlocks.DEEPER_DOWN_PORTAL.get()).defaultBlockState().setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false)));
                    }
                    this.makeRoomAround((Level)targetWorld, portalPos, 4, 2, true, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD);
                    BlockPos targetPos = portalPos.above(2);
                    entity.changeDimension(new DimensionTransition(targetWorld, Vec3.atCenterOf((Vec3i)targetPos), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET)));
                    this.teleportToSafePosition((Level)targetWorld, entity, targetPos, 3);
                }
            }
        }
    }

    public void makeRoomAround(Level world, BlockPos blockPos, int height, int maxWidth, boolean pointingUp, TagKey<Block> tagToClear) {
        BlockState state = world.getBlockState(blockPos);
        if (state.getCollisionShape((BlockGetter)world, blockPos).isEmpty() && state.getCollisionShape((BlockGetter)world, blockPos.above()).isEmpty()) {
            return;
        }
        for (BlockPos pos : DeeperDownPortalBlock.iterateVerticalCone(blockPos, height, maxWidth, pointingUp)) {
            if (world.getBlockEntity(pos) != null || !(state = world.getBlockState(pos)).is(Blocks.BEDROCK) && !state.is(tagToClear)) continue;
            world.destroyBlock(pos, true, null);
        }
    }

    public static Iterable<BlockPos> iterateVerticalCone(BlockPos center, final int height, final int maxWidth, final boolean pointingUp) {
        final int x = center.getX();
        final int y = center.getY();
        final int z = center.getZ();
        return () -> new AbstractIterator<BlockPos>(){
            int xOffset = 0;
            int yOffset = 0;
            int zOffset = 0;
            int currentMaxWidth = 0;
            private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

            protected BlockPos computeNext() {
                if (this.yOffset > height) {
                    return (BlockPos)this.endOfData();
                }
                this.pos.set(x + this.xOffset, pointingUp ? y + this.yOffset : y - this.yOffset, z + this.zOffset);
                ++this.zOffset;
                if (this.zOffset > this.currentMaxWidth) {
                    this.zOffset = -this.currentMaxWidth;
                    ++this.xOffset;
                    if (this.xOffset > this.currentMaxWidth) {
                        this.xOffset = -this.currentMaxWidth;
                        ++this.yOffset;
                        this.currentMaxWidth = Math.min(this.yOffset, maxWidth);
                    }
                }
                return this.pos;
            }
        };
    }

    public void teleportToSafePosition(Level world, Entity entity, BlockPos targetPos, int maxRadius) {
        for (BlockPos bp : BlockPos.withinManhattan((BlockPos)targetPos, (int)maxRadius, (int)maxRadius, (int)maxRadius)) {
            entity.setPos(Vec3.atBottomCenterOf((Vec3i)bp));
            if (world.getBlockState(bp.below()).getCollisionShape((BlockGetter)world, bp.below()) != Shapes.block() || !world.noCollision(entity) || !(entity.getY() < (double)world.getMaxBuildHeight()) || !(entity.getY() > (double)world.getMinBuildHeight())) continue;
            entity.teleportTo((double)bp.getX() + 0.5, (double)bp.getY() + 0.5, (double)bp.getZ() + 0.5);
            return;
        }
        world.removeBlock(targetPos.above(1), false);
        world.removeBlock(targetPos, false);
        world.setBlockAndUpdate(targetPos.below(1), Blocks.COBBLED_DEEPSLATE.defaultBlockState());
        entity.teleportTo((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)FACING_UP)).booleanValue() || random.nextInt(8) == 0) {
            DeeperDownPortalBlock.spawnVoidFogParticle(world, pos, random);
        }
    }

    private static void spawnVoidFogParticle(Level world, BlockPos pos, RandomSource random) {
        double d = (double)pos.getX() + random.nextDouble();
        double e = (double)pos.getY() + 0.3;
        double f = (double)pos.getZ() + random.nextDouble();
        world.addParticle((ParticleOptions)PastelParticleTypes.VOID_FOG, d, e, f, 0.0, 0.1, 0.0);
    }
}

