/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidLogging {
    public static final EnumProperty<State> ANY_INCLUDING_NONE = EnumProperty.create((String)"fluid_logged", State.class);
    public static final EnumProperty<State> ANY_EXCLUDING_NONE = EnumProperty.create((String)"fluid_logged", State.class, (Enum[])new State[]{State.WATER, State.LIQUID_CRYSTAL});
    public static final EnumProperty<State> NONE_AND_CRYSTAL = EnumProperty.create((String)"fluid_logged", State.class, (Enum[])new State[]{State.NOT_LOGGED, State.LIQUID_CRYSTAL});

    public static enum State implements StringRepresentable
    {
        NOT_LOGGED("none", 0),
        WATER("water", 0),
        LIQUID_CRYSTAL("liquid_crystal", 11);

        private final String name;
        private final int luminance;

        private State(String name, int luminance) {
            this.name = name;
            this.luminance = luminance;
        }

        public String getSerializedName() {
            return this.name;
        }

        public FluidState getFluidState() {
            switch (this.ordinal()) {
                case 2: {
                    return ((PastelFluid)((Object)PastelFluids.LIQUID_CRYSTAL.get())).getSource(false);
                }
                case 1: {
                    return Fluids.WATER.getSource(false);
                }
            }
            return Fluids.EMPTY.defaultFluidState();
        }

        public static State getForFluidState(FluidState fluidState) {
            if (fluidState.getType() == PastelFluids.LIQUID_CRYSTAL.get()) {
                return LIQUID_CRYSTAL;
            }
            if (fluidState.is(FluidTags.WATER)) {
                return WATER;
            }
            return NOT_LOGGED;
        }

        public int getLuminance() {
            return this.luminance;
        }

        public boolean isOf(Fluid fluid) {
            return this.getFluidState().is(fluid);
        }

        public boolean isIn(TagKey<Fluid> fluidTag) {
            return this.getFluidState().is(fluidTag);
        }

        public String toString() {
            return this.name;
        }

        public void onEntityCollision(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (this == LIQUID_CRYSTAL) {
                ((PastelFluid)((Object)PastelFluids.LIQUID_CRYSTAL.get())).onEntityCollision(state, world, pos, entity);
            }
        }
    }

    public static interface PastelFluidDrainable
    extends BucketPickup {
        default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos pos, BlockState state) {
            State fluidLog = (State)((Object)state.getValue(ANY_INCLUDING_NONE));
            if (fluidLog == State.WATER) {
                world.setBlock(pos, (BlockState)state.setValue(ANY_INCLUDING_NONE, (Comparable)((Object)State.NOT_LOGGED)), 3);
                if (!state.canSurvive((LevelReader)world, pos)) {
                    world.destroyBlock(pos, true);
                }
                return new ItemStack((ItemLike)Items.WATER_BUCKET);
            }
            if (fluidLog == State.LIQUID_CRYSTAL) {
                world.setBlock(pos, (BlockState)state.setValue(ANY_INCLUDING_NONE, (Comparable)((Object)State.NOT_LOGGED)), 3);
                if (!state.canSurvive((LevelReader)world, pos)) {
                    world.destroyBlock(pos, true);
                }
                return new ItemStack((ItemLike)PastelItems.LIQUID_CRYSTAL_BUCKET.get());
            }
            return ItemStack.EMPTY;
        }

        default public Optional<SoundEvent> getPickupSound() {
            return Fluids.WATER.getPickupSound();
        }
    }

    public static interface PastelFluidFillable
    extends LiquidBlockContainer {
        default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
            return state.getValue(ANY_INCLUDING_NONE) == State.NOT_LOGGED && (fluid == Fluids.WATER || fluid == PastelFluids.LIQUID_CRYSTAL.get());
        }

        default public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
            if (state.getValue(ANY_INCLUDING_NONE) == State.NOT_LOGGED) {
                if (!world.isClientSide()) {
                    if (fluidState.getType() == Fluids.WATER) {
                        world.setBlock(pos, (BlockState)state.setValue(ANY_INCLUDING_NONE, (Comparable)((Object)State.WATER)), 3);
                        world.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)world));
                    } else if (fluidState.getType() == PastelFluids.LIQUID_CRYSTAL.get()) {
                        world.setBlock(pos, (BlockState)state.setValue(ANY_INCLUDING_NONE, (Comparable)((Object)State.LIQUID_CRYSTAL)), 3);
                        world.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)world));
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static interface PastelFluidLoggable
    extends PastelFluidDrainable,
    PastelFluidFillable {
    }
}

