/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.bottomless_bundle;

import earth.terrarium.pastel.api.item.ItemStorage;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleItem;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BottomlessBundleBlockEntity
extends BlockEntity
implements SidedCapabilityProvider {
    private ItemStack bundle;
    private ItemStorage innerStorage;
    private boolean isVoiding;
    protected int powerLevel;
    public IItemHandler storage = new IItemHandler(){

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int i) {
            return BottomlessBundleBlockEntity.this.innerStorage.stack((int)Math.min(BottomlessBundleBlockEntity.this.innerStorage.getCount(), (long)BottomlessBundleBlockEntity.this.innerStorage.stackSize()));
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack;
            }
            int change = BottomlessBundleBlockEntity.this.innerStorage.insert(stack);
            ItemStack remainder = stack.copyWithCount(stack.getCount() - change);
            if (simulate) {
                BottomlessBundleBlockEntity.this.innerStorage.extractPure(change);
                return remainder;
            }
            BottomlessBundleBlockEntity.this.setChanged();
            return BottomlessBundleBlockEntity.this.isVoiding ? ItemStack.EMPTY : remainder;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0) {
                return ItemStack.EMPTY;
            }
            ItemStack result = BottomlessBundleBlockEntity.this.innerStorage.extract(amount);
            if (simulate) {
                BottomlessBundleBlockEntity.this.innerStorage.increment(result.getCount());
                return result;
            }
            BottomlessBundleBlockEntity.this.setChanged();
            return result;
        }

        public int getSlotLimit(int slot) {
            return (int)BottomlessBundleItem.getMaxStoredAmount(BottomlessBundleBlockEntity.this.powerLevel);
        }

        public boolean isItemValid(int i, ItemStack itemStack) {
            return false;
        }
    };

    public BottomlessBundleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.BOTTOMLESS_BUNDLE.get(), pos, state);
        this.bundle = ((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).asItem().getDefaultInstance();
        this.innerStorage = ItemStorage.load(this.bundle).copy();
    }

    public int getStoredAmount() {
        return (int)this.innerStorage.getCount();
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.setBundleUnsynced(ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)nbt.getCompound("Bundle")).orElse(((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).asItem().getDefaultInstance()), registryLookup);
        this.syncStorageWithBundle();
    }

    private void syncBundleWithStorage() {
        assert (this.level != null);
        this.innerStorage.copy().save(this.bundle);
    }

    private void syncStorageWithBundle() {
        this.innerStorage = ItemStorage.load(this.bundle).copy();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.syncBundleWithStorage();
        nbt.put("Bundle", this.bundle.saveOptional(registryLookup));
    }

    private boolean setBundleUnsynced(ItemStack itemStack, HolderLookup.Provider registryLookup) {
        if (itemStack.getItem() instanceof BottomlessBundleItem) {
            this.bundle = itemStack;
            this.isVoiding = EnchantmentHelper.hasTag((ItemStack)this.bundle, PastelEnchantmentTags.DELETES_OVERFLOW);
            this.powerLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)registryLookup.lookup(Registries.ENCHANTMENT).flatMap(impl -> impl.get(Enchantments.POWER)).orElse(null), (ItemStack)itemStack);
            return true;
        }
        return false;
    }

    public void setBundle(@NotNull ItemStack itemStack, HolderLookup.Provider registryLookup) {
        if (this.setBundleUnsynced(itemStack, registryLookup)) {
            this.syncStorageWithBundle();
        }
    }

    public ItemStack retrieveBundle() {
        if (this.bundle.isEmpty()) {
            return ((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).asItem().getDefaultInstance();
        }
        this.syncBundleWithStorage();
        return this.bundle;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return this.storage;
    }
}

