/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.bottomless_bundle;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.ItemPickupListener;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.api.item.ItemStorage;
import earth.terrarium.pastel.api.render.DynamicItemRenderer;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.items.tooltip.ItemStorageTooltipData;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BottomlessBundleItem
extends BlockItem
implements ItemPickupListener,
ItemStorage.LimitCallback {
    private static final long MAX_STORED_AMOUNT_BASE = 20000L;

    public BottomlessBundleItem(Block block, Item.Properties settings) {
        super(block, settings.component(PastelDataComponentTypes.ITEM_STORAGE, (Object)ItemStorage.Component.DEFAULT));
    }

    public static long getMaxStoredAmount(int powerLevel) {
        return 20000L * (long)((int)Math.pow(10.0, Math.min(5, powerLevel)));
    }

    private static boolean dropOneBundledStack(ItemStack bundle, Player player) {
        ItemStorage storage = ItemStorage.load(bundle);
        ItemStack dropped = storage.extract(storage.stackSize());
        if (dropped.isEmpty()) {
            return false;
        }
        player.drop(dropped, true);
        storage.save(bundle);
        return true;
    }

    public static boolean isLocked(ItemStack itemStack) {
        return itemStack.has(DataComponents.LOCK);
    }

    public static ItemReference getStoredReference(ItemStack bundle) {
        return ItemStorage.load(bundle).getReference();
    }

    public static long getStoredAmount(ItemStack bundle) {
        return ItemStorage.load(bundle).getCount();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (user.isShiftKeyDown()) {
            ItemStack handStack = user.getItemInHand(hand);
            if (handStack.has(DataComponents.LOCK)) {
                handStack.remove(DataComponents.LOCK);
                if (world.isClientSide) {
                    this.playZipSound((Entity)user, 0.8f);
                }
            } else {
                handStack.set(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
                if (world.isClientSide) {
                    this.playZipSound((Entity)user, 1.0f);
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        if (BottomlessBundleItem.dropOneBundledStack(itemStack, user)) {
            this.playDropContentsSound((Entity)user);
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    public boolean canFitInsideContainerItems() {
        return true;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack bundle) {
        return Optional.of(new ItemStorageTooltipData(ItemStorage.load(bundle)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        boolean locked = BottomlessBundleItem.isLocked(stack);
        long storedAmount = BottomlessBundleItem.getStoredAmount(stack);
        if (storedAmount == 0L) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.empty").withStyle(ChatFormatting.GRAY));
            if (locked) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.locked").withStyle(ChatFormatting.GRAY));
            }
        } else {
            ItemReference variant = BottomlessBundleItem.getStoredReference(stack);
            Integer powerLevel = context.registries().lookup(Registries.ENCHANTMENT).flatMap(impl -> impl.get(Enchantments.POWER)).map(ench -> EnchantmentHelper.getItemEnchantmentLevel((Holder)ench, (ItemStack)stack)).orElse(0);
            String totalStacks = Support.getShortenedNumberString((float)storedAmount / (float)variant.asItem().getDefaultMaxStackSize());
            tooltip.add((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.count", (Object[])new Object[]{storedAmount, BottomlessBundleItem.getMaxStoredAmount(powerLevel), totalStacks}).withStyle(ChatFormatting.GRAY));
            if (locked) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.locked").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.enter_inventory", (Object[])new Object[]{variant.asItem().getDescription().getString()}).withStyle(ChatFormatting.GRAY));
            }
        }
        if (EnchantmentHelper.hasTag((ItemStack)stack, PastelEnchantmentTags.DELETES_OVERFLOW)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.bottomless_bundle.tooltip.voiding"));
        }
    }

    public void onDestroyed(ItemEntity entity) {
        ItemStorage.Component storage = (ItemStorage.Component)entity.getItem().get(PastelDataComponentTypes.ITEM_STORAGE);
        if (storage != null) {
            entity.getItem().set(PastelDataComponentTypes.ITEM_STORAGE, (Object)ItemStorage.Component.DEFAULT);
            ItemUtils.onContainerDestroyed((ItemEntity)entity, () -> new ItemStorage.IterableView(new ItemStorage(storage.reference(), storage.count())));
        }
    }

    public boolean overrideStackedOnOther(ItemStack bundle, Slot slot, ClickAction clickType, Player player) {
        if (bundle.getCount() != 1 || clickType != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack slotStack = slot.getItem();
        ItemStorage storage = ItemStorage.load(bundle);
        if (slotStack.isEmpty()) {
            ItemStack removed = storage.extract(storage.stackSize());
            if (!removed.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                ItemStack remainder = slot.safeInsert(removed);
                storage.increment(remainder.getCount());
            }
        } else if (slotStack.getItem().canFitInsideContainerItems()) {
            int inserted = storage.insert(slotStack);
            if (inserted > 0) {
                this.playInsertSound((Entity)player);
                slotStack.shrink(inserted);
            } else {
                return false;
            }
        }
        storage.save(bundle);
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack bundle, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (bundle.getCount() != 1 || clickType != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        ItemStorage storage = ItemStorage.load(bundle);
        if (otherStack.isEmpty()) {
            ItemStack removed = storage.extract(storage.stackSize());
            if (!removed.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                cursorStackReference.set(removed);
            }
        } else {
            int inserted = storage.insert(otherStack);
            if (inserted > 0) {
                otherStack.shrink(inserted);
                this.playInsertSound((Entity)player);
            } else {
                return false;
            }
        }
        storage.save(bundle);
        return true;
    }

    public void inventoryTick(ItemStack bundle, Level world, Entity entity, int slot, boolean selected) {
        ItemStorage storage = ItemStorage.load(bundle);
        ItemStack bundled = storage.stack(1);
        int original = (int)Math.min(storage.getCount(), Integer.MAX_VALUE);
        ItemStack ticked = bundled.copyWithCount(original);
        ticked.inventoryTick(world, entity, slot, selected);
        if (!ItemStack.isSameItemSameComponents((ItemStack)bundled, (ItemStack)ticked) || ticked.getCount() != original) {
            storage.setReference(ItemReference.of(ticked));
            storage.setCount(storage.getCount() - (long)(original - ticked.getCount()));
            storage.save(bundle);
        }
    }

    @Override
    public boolean accepts(Optional<ItemStack> listener, ItemStack proposal) {
        assert (listener.isPresent());
        ItemStack bundle = listener.get();
        if (proposal.getCapability(PastelCapabilities.Pickup.ITEM) != null) {
            return false;
        }
        ItemReference reference = BottomlessBundleItem.getStoredReference(bundle);
        return !reference.isEmpty() && reference.permits(proposal);
    }

    @Override
    public ItemStack receive(Optional<ItemStack> listener, ItemStack stack, Optional<Entity> unused) {
        assert (listener.isPresent());
        ItemStack bundle = listener.get();
        if (BottomlessBundleItem.isLocked(bundle)) {
            return stack;
        }
        ItemStorage storage = ItemStorage.load(bundle);
        int inserted = storage.insert(stack);
        storage.save(bundle);
        if (inserted == stack.getCount()) {
            return ItemStack.EMPTY;
        }
        stack.shrink(inserted);
        return stack;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playZipSound(Entity entity, float basePitch) {
        entity.playSound(PastelSounds.BOTTOMLESS_BUNDLE_ZIP, 0.8f, basePitch + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 5;
    }

    @Override
    public long updateLimit(ItemStack holder) {
        if (PastelCommon.getRegistryAccess() == null) {
            return 20000L;
        }
        return BottomlessBundleItem.getMaxStoredAmount(PastelCommon.getRegistryAccess().lookup(Registries.ENCHANTMENT).flatMap(impl -> impl.get(Enchantments.POWER)).map(ench -> EnchantmentHelper.getItemEnchantmentLevel((Holder)ench, (ItemStack)holder)).orElse(0));
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.POWER) || enchantment.is(PastelEnchantments.VOIDING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements DynamicItemRenderer {
        @Override
        public void render(ItemRenderer renderer, ItemStack stack, ItemDisplayContext mode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
            if (mode != ItemDisplayContext.GUI || BottomlessBundleItem.getStoredAmount(stack) <= 0L) {
                return;
            }
            ItemStack bundledStack = ItemStorage.load(stack).stack(1);
            Minecraft client = Minecraft.getInstance();
            BakedModel bundledModel = renderer.getModel(bundledStack, (Level)client.level, (LivingEntity)client.player, 0);
            matrices.pushPose();
            matrices.scale(0.5f, 0.5f, 0.5f);
            matrices.translate(0.5f, 0.5f, 0.5f);
            renderer.render(bundledStack, mode, leftHanded, matrices, vertexConsumers, light, overlay, bundledModel);
            matrices.popPose();
        }
    }

    public static class BottomlessBundlePlacementDispenserBehavior
    extends OptionalDispenseItemBehavior {
        protected ItemStack execute(BlockSource pointer, ItemStack stack) {
            this.setSuccess(false);
            Item item = stack.getItem();
            if (item instanceof BottomlessBundleItem) {
                BottomlessBundleItem bottomlessBundleItem = (BottomlessBundleItem)item;
                Direction direction = (Direction)pointer.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockPos = pointer.pos().relative(direction);
                Direction direction2 = pointer.level().isEmptyBlock(blockPos.below()) ? direction : Direction.UP;
                try {
                    this.setSuccess(bottomlessBundleItem.place((BlockPlaceContext)new DirectionalPlaceContext((Level)pointer.level(), blockPos, direction, stack, direction2)).consumesAction());
                }
                catch (Exception e) {
                    PastelCommon.logError("Error trying to place bottomless bundle at " + String.valueOf(blockPos) + " : " + String.valueOf(e));
                }
            }
            return stack;
        }
    }
}

