/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.chests.BlackHoleChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.PastelChestBlock;
import earth.terrarium.pastel.events.listeners.ItemAndExperienceEventQueue;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlackHoleChestBlock
extends PastelChestBlock {
    public static final MapCodec<BlackHoleChestBlock> CODEC = BlackHoleChestBlock.simpleCodec(BlackHoleChestBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);

    public BlackHoleChestBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlackHoleChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BlackHoleChestBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.BLACK_HOLE_CHEST.get()), BlackHoleChestBlockEntity::tick);
    }

    @Override
    public void openScreen(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlackHoleChestBlockEntity) {
            BlackHoleChestBlockEntity blackHoleChestBlockEntity = (BlackHoleChestBlockEntity)blockEntity;
            if (!BlackHoleChestBlock.isChestBlocked((LevelAccessor)world, pos)) {
                player.openMenu((MenuProvider)blackHoleChestBlockEntity);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel world, T blockEntity) {
        ItemAndExperienceEventQueue itemAndExperienceEventQueue;
        if (blockEntity instanceof BlackHoleChestBlockEntity) {
            BlackHoleChestBlockEntity blackHoleChestBlockEntity = (BlackHoleChestBlockEntity)blockEntity;
            itemAndExperienceEventQueue = blackHoleChestBlockEntity.getEventListener();
        } else {
            itemAndExperienceEventQueue = null;
        }
        return itemAndExperienceEventQueue;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

