/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.blocks.chests.PastelChestBlock;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.events.game.PastelGameEvents;
import earth.terrarium.pastel.events.listeners.EventQueue;
import earth.terrarium.pastel.events.listeners.ExperienceOrbEventQueue;
import earth.terrarium.pastel.events.listeners.ItemAndExperienceEventQueue;
import earth.terrarium.pastel.events.listeners.ItemEntityEventQueue;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.inventories.BlackHoleChestScreenHandler;
import earth.terrarium.pastel.mixin.accessors.ItemEntityAccessor;
import earth.terrarium.pastel.networking.s2c_payloads.BlackHoleChestStatusUpdatePayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlackHoleChestBlockEntity
extends PastelChestBlockEntity
implements FilterConfigurable,
WorldlyContainer,
EventQueue.Callback<Object> {
    public static final int INVENTORY_SIZE = 28;
    public static final int ITEM_FILTER_SLOT_COUNT = 5;
    public static final int EXPERIENCE_STORAGE_PROVIDER_ITEM_SLOT = 27;
    private static final int RANGE = 12;
    private final ItemAndExperienceEventQueue itemAndExperienceEventQueue;
    private final NonNullList<ItemReference> filterItems;
    private State state = State.CLOSED_INACTIVE;
    private boolean isOpen;
    private boolean isFull;
    private boolean hasXPStorage;
    float storageTarget;
    float storagePos;
    float lastStorageTarget;
    float capTarget;
    float capPos;
    float lastCapTarget;
    float orbTarget;
    float orbPos;
    float lastOrbTarget;
    float yawTarget;
    float orbYaw;
    float lastYawTarget;
    long interpTicks;
    long interpLength = 1L;
    long age;
    long storedXP;
    long maxStoredXP;

    public BlackHoleChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.BLACK_HOLE_CHEST.get(), blockPos, blockState);
        this.itemAndExperienceEventQueue = new ItemAndExperienceEventQueue((PositionSource)new BlockPositionSource(this.worldPosition), 12, this);
        this.filterItems = NonNullList.withSize((int)5, (Object)ItemReference.empty());
    }

    public static void tick(@NotNull Level world, BlockPos pos, BlockState state, BlackHoleChestBlockEntity chest) {
        ++chest.age;
        if (chest.isOpen) {
            if (chest.canFunction()) {
                chest.changeState(State.OPEN_ACTIVE);
                chest.interpLength = 7L;
            } else {
                chest.changeState(State.OPEN_INACTIVE);
                chest.interpLength = 5L;
            }
        } else if (chest.isFull) {
            chest.changeState(State.FULL);
            chest.interpLength = 12L;
        } else if (chest.canFunction()) {
            chest.changeState(State.CLOSED_ACTIVE);
            chest.interpLength = 15L;
        } else {
            chest.changeState(State.CLOSED_INACTIVE);
            chest.interpLength = 10L;
        }
        if (chest.interpTicks < chest.interpLength) {
            ++chest.interpTicks;
        }
        if (world.isClientSide) {
            chest.lidAnimator.tickLid();
        } else {
            chest.itemAndExperienceEventQueue.tick(world);
            if (world.getGameTime() % 80L == 0L && !PastelChestBlock.isChestBlocked((LevelAccessor)world, pos)) {
                BlackHoleChestBlockEntity.searchForNearbyEntities(chest);
            }
        }
    }

    public long getRenderTime() {
        return this.age % 50000L;
    }

    public void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.lastCapTarget = this.capPos;
            this.lastOrbTarget = this.orbPos;
            this.lastStorageTarget = this.storagePos;
            this.lastYawTarget = this.orbYaw;
            this.interpTicks = 0L;
        }
    }

    public void updateFullState(boolean force) {
        if (this.level != null && !this.level.isClientSide()) {
            boolean wasFull = this.isFull;
            this.isFull = this.isFull();
            if (force || wasFull != this.isFull) {
                BlackHoleChestStatusUpdatePayload.sendBlackHoleChestUpdate(this);
            }
        }
    }

    public void setXPData(long xp, long max) {
        this.storedXP = xp;
        this.maxStoredXP = max;
    }

    public State getState() {
        return this.state;
    }

    public boolean canFunction() {
        return this.level != null && !PastelChestBlock.isChestBlocked((LevelAccessor)this.level, this.worldPosition) && !this.isFull;
    }

    public boolean isFull() {
        for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.getCount() >= stack.getMaxStackSize()) continue;
            return false;
        }
        if (this.level == null) {
            return true;
        }
        Optional<ExperienceHandler> storage = this.getExperienceStorage();
        return storage.map(experienceHandler -> experienceHandler.getStoredAmount() == experienceHandler.getCapacity()).orElse(true);
    }

    public boolean isFullServer() {
        return this.isFull;
    }

    public void setFull(boolean full) {
        this.isFull = full;
    }

    public void setHasXPStorage(boolean hasXPStorage) {
        this.hasXPStorage = hasXPStorage;
    }

    public boolean hasXPStorage() {
        return this.hasXPStorage;
    }

    private static void searchForNearbyEntities(@NotNull BlackHoleChestBlockEntity blockEntity) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            return;
        }
        List itemEntities = world.getEntities((EntityTypeTest)EntityType.ITEM, BlackHoleChestBlockEntity.getBoxWithRadius(blockEntity.worldPosition, 12), Entity::isAlive);
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.isAlive() || itemEntity.getItem().isEmpty()) continue;
            itemEntity.gameEvent(PastelGameEvents.ENTITY_SPAWNED);
        }
        List experienceOrbEntities = world.getEntities((EntityTypeTest)EntityType.EXPERIENCE_ORB, BlackHoleChestBlockEntity.getBoxWithRadius(blockEntity.worldPosition, 12), Entity::isAlive);
        for (ExperienceOrb experienceOrbEntity : experienceOrbEntities) {
            if (!experienceOrbEntity.isAlive()) continue;
            experienceOrbEntity.gameEvent(PastelGameEvents.ENTITY_SPAWNED);
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    protected static AABB getBoxWithRadius(BlockPos blockPos, int radius) {
        return AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)radius, (double)radius, (double)radius);
    }

    @Override
    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.isOpen = data > 0;
        }
        return super.triggerEvent(type, data);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.pastel.black_hole_chest");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new BlackHoleChestScreenHandler(syncId, playerInventory, this, new FilterConfigurable.ExtendedData(this));
    }

    @Override
    protected void onInvOpenOrClose(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        super.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
        this.updateFullState(true);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        FilterConfigurable.writeFilterNbt(tag, this.filterItems, registryLookup);
        tag.putLong("age", this.age);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        FilterConfigurable.readFilterNbt(tag, this.filterItems, registryLookup);
        this.age = tag.getLong("age");
    }

    public int getContainerSize() {
        return 28;
    }

    public ItemAndExperienceEventQueue getEventListener() {
        return this.itemAndExperienceEventQueue;
    }

    @Override
    public boolean canAcceptEvent(Level world, GameEventListener listener, GameEvent.ListenerInfo event, Vec3 sourcePos) {
        if (PastelChestBlock.isChestBlocked((LevelAccessor)world, this.worldPosition)) {
            return false;
        }
        Entity entity = event.context().sourceEntity();
        if (entity instanceof ItemEntity) {
            return true;
        }
        return entity instanceof ExperienceOrb && this.getExperienceStorage().isPresent();
    }

    @Override
    public void triggerEvent(Level world, GameEventListener listener, Object entry) {
        if (PastelChestBlock.isChestBlocked((LevelAccessor)world, this.worldPosition)) {
            return;
        }
        if (entry instanceof ExperienceOrbEventQueue.EventEntry) {
            ExperienceOrbEventQueue.EventEntry experienceEntry = (ExperienceOrbEventQueue.EventEntry)entry;
            ExperienceOrb experienceOrbEntity = experienceEntry.experienceOrbEntity;
            Optional<ExperienceHandler> storage = this.getExperienceStorage();
            if (storage.isPresent() && experienceOrbEntity != null && experienceOrbEntity.isAlive()) {
                storage.get().insert(experienceOrbEntity.getValue(), false);
                BlackHoleChestBlockEntity.sendPlayExperienceOrbEntityAbsorbedParticle((ServerLevel)world, experienceOrbEntity);
                world.playSound(null, experienceOrbEntity.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.9f + world.random.nextFloat() * 0.2f);
                experienceOrbEntity.remove(Entity.RemovalReason.DISCARDED);
            }
        } else if (entry instanceof ItemEntityEventQueue.EventEntry) {
            ItemEntityEventQueue.EventEntry itemEntry = (ItemEntityEventQueue.EventEntry)entry;
            ItemEntity itemEntity = itemEntry.itemEntity;
            if (itemEntity != null && itemEntity.isAlive() && ((ItemEntityAccessor)itemEntity).getPickupDelay() != Short.MAX_VALUE && this.acceptsItemStack(itemEntity.getItem())) {
                int previousAmount = itemEntity.getItem().getCount();
                ItemStack remainingStack = InventoryHelper.smartAddToInventory(itemEntity.getItem(), (IItemHandlerModifiable)this.exposeItemHandlers(Direction.UP), Direction.UP);
                if (remainingStack.isEmpty()) {
                    BlackHoleChestBlockEntity.sendPlayItemEntityAbsorbedParticle((ServerLevel)world, itemEntity);
                    world.playSound(null, itemEntity.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.9f + world.random.nextFloat() * 0.2f);
                    itemEntity.setItem(ItemStack.EMPTY);
                    itemEntity.discard();
                } else if (remainingStack.getCount() != previousAmount) {
                    BlackHoleChestBlockEntity.sendPlayItemEntityAbsorbedParticle((ServerLevel)world, itemEntity);
                    world.playSound(null, itemEntity.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.9f + world.random.nextFloat() * 0.2f);
                    itemEntity.setItem(remainingStack);
                }
            }
        }
    }

    public static void sendPlayItemEntityAbsorbedParticle(ServerLevel world, @NotNull ItemEntity itemEntity) {
        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity(world, itemEntity.position(), (ParticleOptions)PastelParticleTypes.BLUE_BUBBLE_POP, 1, Vec3.ZERO);
    }

    public static void sendPlayExperienceOrbEntityAbsorbedParticle(ServerLevel world, @NotNull ExperienceOrb experienceOrbEntity) {
        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity(world, experienceOrbEntity.position(), (ParticleOptions)PastelParticleTypes.GREEN_BUBBLE_POP, 1, Vec3.ZERO);
    }

    @Override
    public SoundEvent getOpenSound() {
        return PastelSounds.BLACK_HOLE_CHEST_OPEN;
    }

    @Override
    public SoundEvent getCloseSound() {
        return PastelSounds.BLACK_HOLE_CHEST_CLOSE;
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        FilterConfigurable.ExtendedDataWithPos.STREAM_CODEC.encode((Object)buffer, (Object)new FilterConfigurable.ExtendedDataWithPos(this.worldPosition, this));
    }

    @Override
    public NonNullList<ItemReference> getItemFilters() {
        return this.filterItems;
    }

    @Override
    public int getSlotsPerRow() {
        return 5;
    }

    @Override
    public int getDrawnSlots() {
        return 5;
    }

    @Override
    public void setFilterItem(int slot, ItemStack item) {
        this.filterItems.set(slot, (Object)ItemReference.of(item));
        this.setChanged();
    }

    public boolean acceptsItemStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        boolean allAir = true;
        for (int i = 0; i < 5; ++i) {
            ItemReference filterItem = (ItemReference)this.filterItems.get(i);
            if (filterItem.permits(itemStack)) {
                return true;
            }
            if (filterItem.isEmpty()) continue;
            allAir = false;
        }
        return allAir;
    }

    public Optional<ExperienceHandler> getExperienceStorage() {
        assert (this.level != null);
        return Optional.ofNullable((ExperienceHandler)this.inventory.getStackInSlot(27).getCapability(PastelCapabilities.Misc.XP, (Object)this.level.registryAccess()));
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.rangeClosed(0, 26).toArray();
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return true;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.updateFullState(false);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = super.removeItem(slot, amount);
        if (!stack.isEmpty()) {
            this.updateFullState(false);
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = super.removeItemNoUpdate(slot);
        if (!stack.isEmpty()) {
            this.updateFullState(false);
        }
        return stack;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return new StackHandlerView(this.inventory, 0, 27);
    }

    public static enum State {
        OPEN_INACTIVE,
        OPEN_ACTIVE,
        CLOSED_ACTIVE,
        CLOSED_INACTIVE,
        FULL;

    }
}

