/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.chests.BlackHoleChestBlockEntity;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BlackHoleChestBlockEntityRenderer
implements BlockEntityRenderer<BlackHoleChestBlockEntity> {
    private static final Material defaultSprite = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/black_hole_chest"));
    private static final Material experienceSprite = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/black_hole_chest_experience"));
    private final ModelPart root;
    private final ModelPart shell;
    private final ModelPart cap;
    private final ModelPart storage;
    private final ModelPart orb;

    public BlackHoleChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        LayerDefinition texturedModelData = BlackHoleChestBlockEntityRenderer.getTexturedModelData();
        this.root = texturedModelData.bakeRoot();
        this.shell = this.root.getChild("shell");
        this.cap = this.root.getChild("cap");
        this.storage = this.root.getChild("storage");
        this.orb = this.root.getChild("orb");
    }

    @NotNull
    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition shell = modelPartData.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -9.0f, -7.0f, 14.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-5.0f, -9.0f, -5.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cap = modelPartData.addOrReplaceChild("cap", CubeListBuilder.create().texOffs(40, 39).addBox(-5.0f, -6.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(82, 2).addBox(-4.0f, -5.0f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition storage = modelPartData.addOrReplaceChild("storage", CubeListBuilder.create().texOffs(42, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(56, 13).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition orb = modelPartData.addOrReplaceChild("orb", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 39).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.4f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void render(BlackHoleChestBlockEntity chest, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        int orbLight;
        poseStack.pushPose();
        Material sprite = chest.hasXPStorage() ? experienceSprite : defaultSprite;
        boolean bl = chest.getLevel() != null;
        BlockState blockState = bl ? chest.getBlockState() : (BlockState)((Block)PastelBlocks.BLACK_HOLE_CHEST.get()).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        float f = blockState.hasProperty((Property)ChestBlock.FACING) ? ((Direction)blockState.getValue((Property)ChestBlock.FACING)).toYRot() : 0.0f;
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        long time = chest.getRenderTime();
        double orbTransform = Math.sin(((float)time + tickDelta) / 9.0f);
        float potentialYaw = ((float)time + tickDelta) / 6.0f;
        switch (chest.getState()) {
            case OPEN_ACTIVE: {
                chest.storageTarget = 9.0f;
                chest.capTarget = 12.0f;
                chest.orbTarget = (float)(15.0 + orbTransform);
                chest.yawTarget = potentialYaw;
                break;
            }
            case OPEN_INACTIVE: {
                chest.storageTarget = 9.0f;
                chest.orbTarget = chest.capTarget = 12.0f;
                break;
            }
            case CLOSED_ACTIVE: {
                chest.capTarget = 0.0f;
                chest.storageTarget = 0.0f;
                chest.orbTarget = (float)(12.5 + orbTransform * 2.5);
                chest.yawTarget = potentialYaw;
                break;
            }
            case CLOSED_INACTIVE: {
                chest.storageTarget = chest.capTarget = 0.0f;
                chest.orbTarget = chest.capTarget;
                break;
            }
            case FULL: {
                chest.storageTarget = chest.capTarget = 9.0f;
                chest.orbTarget = chest.capTarget;
            }
        }
        float interp = Mth.clamp((float)(((float)chest.interpTicks + tickDelta) / (float)chest.interpLength), (float)0.0f, (float)1.0f);
        chest.capPos = Mth.lerp((float)interp, (float)chest.lastCapTarget, (float)chest.capTarget);
        chest.storagePos = Mth.lerp((float)interp, (float)chest.lastStorageTarget, (float)chest.storageTarget);
        chest.orbPos = Mth.lerp((float)interp, (float)chest.lastOrbTarget, (float)chest.orbTarget);
        chest.orbYaw = Mth.lerp((float)interp, (float)chest.lastYawTarget, (float)chest.yawTarget);
        this.cap.y = 24.0f - chest.capPos;
        this.storage.y = 24.0f - chest.storagePos;
        this.orb.y = 15.4f - chest.orbPos;
        this.orb.yRot = chest.yawTarget;
        this.storage.skipDraw = this.storage.y > 23.99f;
        VertexConsumer vertexConsumer = sprite.buffer(vertexConsumers, RenderType::entityTranslucent);
        this.cap.render(poseStack, vertexConsumer, light, overlay);
        this.shell.render(poseStack, vertexConsumer, light, overlay);
        this.storage.render(poseStack, vertexConsumer, light, overlay);
        if (chest.hasXPStorage()) {
            float xpDelta = (float)chest.storedXP / (float)chest.maxStoredXP;
            int altLight = Math.round(Mth.clampedLerp((float)0.0f, (float)15.0f, (float)xpDelta));
            orbLight = LightTexture.pack((int)altLight, (int)altLight);
        } else {
            orbLight = light;
        }
        this.orb.visit(poseStack, (matrix, path, index, cuboid) -> cuboid.compile(poseStack.last(), vertexConsumer, index == 0 ? orbLight : light, overlay, -1));
        poseStack.popPose();
    }
}

