/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.chests.CompactingChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.PastelChestBlock;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompactingChestBlock
extends PastelChestBlock {
    public static final MapCodec<CompactingChestBlock> CODEC = CompactingChestBlock.simpleCodec(CompactingChestBlock::new);

    public CompactingChestBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CompactingChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return CompactingChestBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.COMPACTING_CHEST.get()), CompactingChestBlockEntity::tick);
    }

    @Override
    public void openScreen(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CompactingChestBlockEntity) {
            CompactingChestBlockEntity compactingChestBlockEntity = (CompactingChestBlockEntity)blockEntity;
            if (!CompactingChestBlock.isChestBlocked((LevelAccessor)world, pos)) {
                player.openMenu((MenuProvider)compactingChestBlockEntity);
            }
        }
    }
}

