/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.chests.CompactingChestBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CompactingChestBlockEntityRenderer
implements BlockEntityRenderer<CompactingChestBlockEntity> {
    private static final Material SPRITE_IDENTIFIER = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/compacting_chest"));
    private final ModelPart root;
    private final ModelPart driver;
    private final ModelPart piston;
    private final ModelPart cap;

    public CompactingChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        LayerDefinition texturedModelData = CompactingChestBlockEntityRenderer.getTexturedModelData();
        this.root = texturedModelData.bakeRoot();
        ModelPart fakeRoot = this.root.getChild("root");
        this.driver = fakeRoot.getChild("driver");
        this.piston = fakeRoot.getChild("piston");
        this.cap = fakeRoot.getChild("cap");
    }

    @NotNull
    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create().texOffs(81, 44).addBox(-1.5f, -10.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -11.0f, -7.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(-5.0f, -11.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-7.5f, -2.0f, -7.5f, 15.0f, 2.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition driver = root.addOrReplaceChild("driver", CubeListBuilder.create().texOffs(53, 38).addBox(-3.5f, -36.0f, -3.5f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition piston = root.addOrReplaceChild("piston", CubeListBuilder.create().texOffs(89, 17).addBox(-3.5f, 7.0f, -3.5f, 7.0f, 14.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(45, 13).addBox(-5.5f, 7.0f, -5.5f, 11.0f, 14.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-22.0f, (float)0.0f));
        PartDefinition cap = root.addOrReplaceChild("cap", CubeListBuilder.create().texOffs(0, 24).addBox(-7.5f, -36.0f, -7.5f, 15.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(40, 65).addBox(-5.5f, -36.0f, -5.5f, 11.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void render(CompactingChestBlockEntity chest, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (chest.animator == null || chest.getLevel() == null) {
            return;
        }
        chest.animator.animate(tickDelta, chest.getLevel().getGameTime() % 100000L);
        poseStack.pushPose();
        float f = ((Direction)chest.getBlockState().getValue((Property)ChestBlock.FACING)).toYRot();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        this.piston.y = -22.0f - chest._piston.get().floatValue();
        this.driver.y = 21.0f - chest._driver.get().floatValue();
        this.cap.y = 21.0f - chest._cap.get().floatValue();
        VertexConsumer vertexConsumer = SPRITE_IDENTIFIER.buffer(vertexConsumers, RenderType::entityCutoutNoCull);
        this.root.render(poseStack, vertexConsumer, light, overlay);
        poseStack.popPose();
    }
}

