/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.chests.FabricationChestBlockEntity;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FabricationChestBlockEntityRenderer
implements BlockEntityRenderer<FabricationChestBlockEntity> {
    private static final Material spriteIdentifier = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/fabrication_chest"));
    private final ModelPart rootNode;
    private final ModelPart root;
    private final ModelPart rim;
    private final ModelPart crafting_tablet;
    private final ModelPart assembly;
    private final ModelPart rings;

    public FabricationChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        LayerDefinition texturedModelData = FabricationChestBlockEntityRenderer.getTexturedModelData();
        this.rootNode = texturedModelData.bakeRoot();
        this.root = this.rootNode.getChild("root");
        this.rim = this.root.getChild("rim");
        this.crafting_tablet = this.root.getChild("crafting_tablet");
        this.assembly = this.root.getChild("assembly");
        this.rings = this.root.getChild("rings");
    }

    @NotNull
    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("rim", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -3.0f, -8.0f, 16.0f, 4.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(52, 49).addBox(-6.0f, -3.0f, -6.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)0.0f));
        root.addOrReplaceChild("crafting_tablet", CubeListBuilder.create().texOffs(48, 0).addBox(-6.5f, 2.0f, -8.5f, 13.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.0f, (float)2.0f));
        root.addOrReplaceChild("assembly", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        root.addOrReplaceChild("rings", CubeListBuilder.create().texOffs(-13, 60).addBox(-6.5f, 1.25f, -6.5f, 13.0f, 0.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(41, 65).addBox(-5.5f, -1.25f, -5.5f, 11.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-17.25f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void render(FabricationChestBlockEntity chest, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        List<ItemStack> outputs;
        Level world = chest.getLevel();
        boolean bl = world != null;
        BlockState blockState = bl ? chest.getBlockState() : (BlockState)((Block)PastelBlocks.FABRICATION_CHEST.get()).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        matrices.pushPose();
        float f = blockState.hasProperty((Property)ChestBlock.FACING) ? ((Direction)blockState.getValue((Property)ChestBlock.FACING)).toYRot() : 0.0f;
        matrices.translate(0.5, 1.5, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees(-f));
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        long time = chest.getRenderTime();
        float transform = (float)Math.sin(((float)time + tickDelta) / 13.0f);
        switch (chest.getState()) {
            case FULL: {
                chest.tabletTarget = 0.0f;
                chest.rimTarget = 0.0f;
                chest.assemblyTarget = 0.0f;
                chest.ringTarget = 0.0f;
                chest.itemTarget = 0.0f;
                chest.alphaTarget = 0.0f;
                chest.yawModTarget = 0.0f;
                break;
            }
            case CLOSED_CRAFTING: {
                chest.tabletTarget = 2.0f;
                chest.rimTarget = 0.0f;
                chest.assemblyTarget = 2.0f;
                chest.ringTarget = 2.0f + transform;
                chest.itemTarget = 12.0f + transform * 1.5f;
                chest.alphaTarget = 0.667f;
                chest.yawModTarget = 0.334f;
                break;
            }
            case CLOSED: {
                chest.tabletTarget = 0.0f;
                chest.rimTarget = 0.0f;
                chest.assemblyTarget = 1.0f;
                chest.ringTarget = 0.5f + transform / 2.5f;
                chest.itemTarget = 9.5f + transform / 2.125f;
                chest.alphaTarget = 0.2f;
                chest.yawModTarget = 0.05f;
                break;
            }
            case OPEN_CRAFTING: {
                chest.tabletTarget = 5.0f;
                chest.rimTarget = 7.0f;
                chest.assemblyTarget = 5.0f;
                chest.ringTarget = 6.25f + transform / 1.664f;
                chest.itemTarget = 15.25f + transform / 1.334f;
                chest.alphaTarget = 0.4f;
                chest.yawModTarget = 0.175f;
                break;
            }
            case OPEN: {
                chest.tabletTarget = 5.0f;
                chest.rimTarget = 7.0f;
                chest.assemblyTarget = 5.0f;
                chest.ringTarget = 5.25f + transform / 2.5f;
                chest.itemTarget = 13.25f + transform / 2.4f;
                chest.yawModTarget = 0.05f;
            }
        }
        float interp = Mth.clamp((float)(((float)chest.interpTicks + tickDelta) / (float)chest.interpLength), (float)0.0f, (float)1.0f);
        chest.tabletPos = Mth.lerp((float)interp, (float)chest.lastTabletTarget, (float)chest.tabletTarget);
        chest.rimPos = Mth.lerp((float)interp, (float)chest.lastRimTarget, (float)chest.rimTarget);
        chest.assemblyPos = Mth.lerp((float)interp, (float)chest.lastAssemblyTarget, (float)chest.assemblyTarget);
        chest.ringPos = Mth.lerp((float)interp, (float)chest.lastRingTarget, (float)chest.ringTarget);
        chest.itemPos = Mth.lerp((float)interp, (float)chest.lastItemTarget, (float)chest.itemTarget);
        chest.alphaValue = Mth.lerp((float)interp, (float)chest.lastAlphaTarget, (float)chest.alphaTarget);
        chest.yawMod = Mth.lerp((float)interp, (float)chest.lastYawModTarget, (float)chest.yawModTarget);
        this.rim.y = 15.0f - chest.rimPos;
        this.crafting_tablet.y = 9.0f - chest.tabletPos;
        this.assembly.y = 18.0f - chest.assemblyPos;
        this.rings.y = 6.75f - chest.ringPos;
        this.rings.yRot = Mth.lerp((float)tickDelta, (float)chest.lastYaw, (float)chest.yaw);
        VertexConsumer vertexConsumer = spriteIdentifier.buffer(vertexConsumers, RenderType::entityTranslucent);
        this.rim.render(matrices, vertexConsumer, light, overlay);
        this.crafting_tablet.render(matrices, vertexConsumer, light, overlay);
        if (chest.rimPos > 0.01f) {
            this.assembly.render(matrices, vertexConsumer, light, overlay);
        }
        if (chest.alphaValue > 0.01f) {
            this.rings.render(matrices, vertexConsumer, 0xF000F0, overlay, FastColor.ARGB32.colorFromFloat((float)chest.alphaValue, (float)1.0f, (float)1.0f, (float)1.0f));
        }
        if ((outputs = chest.getRecipeOutputs()).isEmpty()) {
            matrices.popPose();
            return;
        }
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.YP.rotation(-this.rings.yRot));
        matrices.translate(0.0, -1.5 + (12.5 + (double)chest.itemPos) / 16.0, 0.0);
        matrices.scale(0.8f, 0.8f, 0.8f);
        if (outputs.size() == 1) {
            Minecraft.getInstance().getItemRenderer().renderStatic(null, outputs.getFirst(), ItemDisplayContext.GROUND, false, matrices, vertexConsumers, world, light, overlay, 0);
        } else {
            float rotation = 360.0f / (float)outputs.size();
            for (ItemStack output : outputs) {
                matrices.mulPose(Axis.YP.rotationDegrees(rotation));
                matrices.translate(0.4f, 0.0f, 0.0f);
                matrices.mulPose(Axis.YP.rotationDegrees(this.rings.yRot * 0.8f));
                Minecraft.getInstance().getItemRenderer().renderStatic(null, output, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, world, light, overlay, 0);
                matrices.mulPose(Axis.YP.rotationDegrees(-this.rings.yRot * 0.8f));
                matrices.translate(-0.4f, 0.0f, 0.0f);
            }
        }
        matrices.popPose();
    }
}

