/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.chests.PastelChestBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PastelChestBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected final ModelPart singleChestLid;
    protected final ModelPart singleChestBase;
    protected final ModelPart singleChestLatch;

    public PastelChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart modelPart = this.getModel(ctx);
        this.singleChestBase = modelPart.getChild("bottom");
        this.singleChestLid = modelPart.getChild("lid");
        this.singleChestLatch = modelPart.getChild("lock");
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.getLevel();
        boolean bl = world != null;
        BlockState blockState = bl ? entity.getBlockState() : (BlockState)((Block)PastelBlocks.HEARTBOUND_CHEST.get()).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockState.getBlock();
        if (block instanceof PastelChestBlock) {
            PastelChestBlock spectrumChestBlock = (PastelChestBlock)block;
            matrices.pushPose();
            float f = ((Direction)blockState.getValue((Property)ChestBlock.FACING)).toYRot();
            matrices.translate(0.5, 0.5, 0.5);
            matrices.mulPose(Axis.YP.rotationDegrees(-f));
            matrices.translate(-0.5, -0.5, -0.5);
            float openFactor = ((LidBlockEntity)entity).getOpenNess(tickDelta);
            openFactor = 1.0f - openFactor;
            openFactor = 1.0f - openFactor * openFactor * openFactor;
            VertexConsumer vertexConsumer = spectrumChestBlock.getTextureLocation().buffer(vertexConsumers, RenderType::entityCutout);
            this.render(matrices, vertexConsumer, this.singleChestLid, this.singleChestLatch, this.singleChestBase, openFactor, light, overlay);
            matrices.popPose();
        }
    }

    private void render(PoseStack matrices, VertexConsumer vertices, ModelPart lid, ModelPart latch, ModelPart base, float openFactor, int light, int overlay) {
        latch.xRot = lid.xRot = -(openFactor * 1.5707964f);
        lid.render(matrices, vertices, light, overlay);
        latch.render(matrices, vertices, light, overlay);
        base.render(matrices, vertices, light, overlay);
    }

    protected ModelPart getModel(BlockEntityRendererProvider.Context ctx) {
        return ctx.bakeLayer(ModelLayers.CHEST);
    }
}

