/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.conditional.amaranth;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.TallCropBlock;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AmaranthCropBlock
extends TallCropBlock {
    public static final MapCodec<AmaranthCropBlock> CODEC = AmaranthCropBlock.simpleCodec(AmaranthCropBlock::new);
    protected static final int LAST_SINGLE_BLOCK_AGE = 2;
    protected static final int MAX_AGE = 7;
    private static final VoxelShape[] AGE_TO_SHAPE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};

    public AmaranthCropBlock(BlockBehaviour.Properties settings) {
        super(settings, 2);
    }

    public MapCodec<? extends AmaranthCropBlock> codec() {
        return CODEC;
    }

    public int getMaxAge() {
        return 7;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)PastelItems.AMARANTH_GRAINS.get();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            if ((Integer)state.getValue((Property)AGE) <= this.lastSingleBlockAge) {
                return AGE_TO_SHAPE[(Integer)state.getValue((Property)this.getAgeProperty())];
            }
            return Shapes.block();
        }
        return AGE_TO_SHAPE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }
}

