/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decay;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.decay.DecayAwayBlock;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DecayBlock
extends Block {
    public static final EnumProperty<Conversion> CONVERSION = EnumProperty.create((String)"conversion", Conversion.class);
    protected final float spreadChance;
    protected final boolean canSpreadToBlockEntities;
    protected final float damageOnTouching;
    protected final int tier;

    public DecayBlock(BlockBehaviour.Properties settings, float spreadChance, boolean canSpreadToBlockEntities, int tier, float damageOnTouching) {
        super(settings);
        this.spreadChance = spreadChance;
        this.canSpreadToBlockEntities = canSpreadToBlockEntities;
        this.damageOnTouching = damageOnTouching;
        this.tier = tier;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{CONVERSION});
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            Integer frostWalker;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.fireImmune() && (frostWalker = world.registryAccess().lookup(Registries.ENCHANTMENT).flatMap(impl -> impl.get(Enchantments.FROST_WALKER)).map(e -> EnchantmentHelper.getEnchantmentLevel((Holder)e, (LivingEntity)livingEntity)).orElse(0)) == 0) {
                entity.hurt(PastelDamageTypes.decay(world), this.damageOnTouching);
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide && PastelCommon.CONFIG.LogPlacingOfDecay && placer != null) {
            PastelCommon.logInfo(state.getBlock().getName().getString() + " was placed in " + String.valueOf(world.dimension().location()) + " at " + pos.getX() + " " + pos.getY() + " " + pos.getZ() + " by " + String.valueOf(placer.getName()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Conversion)((Object)state.getValue(CONVERSION))).equals((Object)Conversion.SPECIAL)) {
            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)((float)pos.getX() + random.nextFloat()), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSpreadTo(Level world, BlockPos targetBlockPos, BlockState stateAtTargetPos) {
        Block block;
        if (PastelCommon.CONFIG.DecayIsStoppedByClaimMods && !GenericClaimModsCompat.canModify(world, targetBlockPos, null)) {
            return false;
        }
        if (!this.canSpreadToBlockEntities) {
            if (world.getBlockEntity(targetBlockPos) != null) return false;
        }
        if ((block = stateAtTargetPos.getBlock()) instanceof DecayBlock) {
            DecayBlock decayBlock = (DecayBlock)block;
            if (this.tier <= decayBlock.tier) return false;
        }
        if (stateAtTargetPos.getBlock() == Blocks.BEDROCK) return true;
        if (!(stateAtTargetPos.getBlock().defaultDestroyTime() > -1.0f)) return false;
        if (!(stateAtTargetPos.getBlock().getExplosionResistance() < 10000.0f)) return false;
        return true;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block previousBlock, BlockPos fromPos, boolean notify) {
        BlockState spreadState;
        BlockState updatedState;
        Block updatedBlock;
        super.neighborChanged(state, world, pos, previousBlock, fromPos, notify);
        if (previousBlock == Blocks.AIR && !((updatedBlock = (updatedState = world.getBlockState(fromPos)).getBlock()) instanceof DecayBlock) && !(updatedBlock instanceof DecayAwayBlock) && (spreadState = this.getSpreadState(state, updatedState, world, fromPos)) != null) {
            world.scheduleTick(pos, (Block)this, 40 + world.random.nextInt(200), TickPriority.EXTREMELY_LOW);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.randomTick(state, world, pos, random);
        this.trySpreadToRandomNeighboringBlock(state, world, pos);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.spreadChance < 1.0f && random.nextFloat() > this.spreadChance) {
            return;
        }
        Direction randomDirection = Direction.getRandom((RandomSource)random);
        this.trySpreadInDirection((Level)world, state, pos, randomDirection);
    }

    private void trySpreadToRandomNeighboringBlock(BlockState state, ServerLevel world, BlockPos pos) {
        Direction direction;
        ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.values()));
        Collections.shuffle(directions);
        Iterator iterator = directions.iterator();
        while (iterator.hasNext() && !this.trySpreadInDirection((Level)world, state, pos, direction = (Direction)iterator.next())) {
        }
    }

    protected boolean trySpreadInDirection(@NotNull Level world, BlockState state, @NotNull BlockPos originPos, Direction direction) {
        BlockState spreadState;
        BlockState targetBlockState;
        BlockPos targetPos = originPos.relative(direction);
        if (this.canSpreadTo(world, targetPos, targetBlockState = world.getBlockState(targetPos)) && (spreadState = this.getSpreadState(state, targetBlockState, world, targetPos)) != null && world.setBlockAndUpdate(targetPos, spreadState)) {
            world.playSound(null, targetPos, spreadState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract BlockState getSpreadState(BlockState var1, BlockState var2, Level var3, BlockPos var4);

    public static enum Conversion implements StringRepresentable
    {
        NONE("none"),
        DEFAULT("default"),
        SPECIAL("special");

        private final String name;

        private Conversion(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

