/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decay;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.decay.DecayBlock;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FadingBlock
extends DecayBlock {
    public static final MapCodec<FadingBlock> CODEC = FadingBlock.simpleCodec(FadingBlock::new);

    public FadingBlock(BlockBehaviour.Properties settings) {
        super(settings, PastelCommon.CONFIG.FadingDecayTickRate, PastelCommon.CONFIG.FadingCanDestroyBlockEntities, 1, 1.0f);
    }

    protected MapCodec<? extends FadingBlock> codec() {
        return CODEC;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            world.playSound(null, pos, PastelSounds.FADING_PLACED, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else {
            RandomSource random = world.getRandom();
            world.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)((-1.0f + random.nextFloat() * 2.0f) / 12.0f), 0.05, (double)((-1.0f + random.nextFloat() * 2.0f) / 12.0f));
            for (int i = 0; i < 10; ++i) {
                world.addParticle((ParticleOptions)ColoredCraftingParticleEffect.GRAY, (double)((float)pos.getX() + random.nextFloat()), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat()), (double)((-1.0f + random.nextFloat() * 2.0f) / 12.0f), 0.05, (double)((-1.0f + random.nextFloat() * 2.0f) / 12.0f));
            }
        }
    }

    @Override
    @Nullable
    protected BlockState getSpreadState(BlockState stateToSpreadFrom, BlockState stateToSpreadTo, Level world, BlockPos stateToSpreadToPos) {
        if (stateToSpreadTo.is(PastelBlockTags.FADING_SPECIAL_CONVERSIONS)) {
            return (BlockState)stateToSpreadFrom.setValue((Property)CONVERSION, (Comparable)((Object)DecayBlock.Conversion.SPECIAL));
        }
        if (stateToSpreadTo.is(PastelBlockTags.FADING_CONVERSIONS)) {
            return (BlockState)stateToSpreadFrom.setValue((Property)CONVERSION, (Comparable)((Object)DecayBlock.Conversion.DEFAULT));
        }
        return null;
    }
}

