/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.decoration.ProjectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ProjectorBlock
extends Block
implements EntityBlock {
    public static final MapCodec<ProjectorBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ProjectorBlock.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(b -> b.texture), (App)Codec.DOUBLE.fieldOf("width").forGetter(b -> b.width), (App)Codec.DOUBLE.fieldOf("height").forGetter(b -> b.height), (App)Codec.FLOAT.fieldOf("heightOffset").forGetter(b -> Float.valueOf(b.heightOffset)), (App)Codec.FLOAT.fieldOf("bobMultiplier").forGetter(b -> Float.valueOf(b.bobMultiplier)), (App)Codec.FLOAT.fieldOf("scaling").forGetter(b -> Float.valueOf(b.scaling))).apply((Applicative)i, ProjectorBlock::new));
    private final double width;
    private final double height;
    private final VoxelShape shape;
    final float heightOffset;
    final float bobMultiplier;
    final float scaling;
    final ResourceLocation texture;

    public ProjectorBlock(BlockBehaviour.Properties settings, String path, double width, double height, float heightOffset, float bobMultiplier, float scaling) {
        this(settings, PastelCommon.locate("textures/block/" + path + ".png"), width, height, heightOffset, bobMultiplier, scaling);
    }

    public ProjectorBlock(BlockBehaviour.Properties settings, ResourceLocation texture, double width, double height, float heightOffset, float bobMultiplier, float scaling) {
        super(settings);
        this.heightOffset = heightOffset;
        this.bobMultiplier = bobMultiplier;
        this.scaling = scaling;
        this.width = width;
        this.height = height;
        double min = (16.0 - width) / 2.0;
        double max = width + min;
        this.shape = Block.box((double)min, (double)0.0, (double)min, (double)max, (double)height, (double)max);
        this.texture = texture;
    }

    public MapCodec<? extends ProjectorBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ProjectorBlockEntity(pos, state);
    }
}

