/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PylonBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<PylonBlock> CODEC = PylonBlock.simpleCodec(PylonBlock::new);
    public static final EnumProperty<Section> SECTION = EnumProperty.create((String)"section", Section.class);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty PEDESTAL = BooleanProperty.create((String)"pedestal");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Map<Direction.Axis, VoxelShape> PYLON_SHAPES;
    public static final Map<Direction, VoxelShape> PEDESTAL_SHAPES;

    public PylonBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(SECTION, (Comparable)((Object)Section.FOOT))).setValue(FACING, (Comparable)Direction.UP)).setValue((Property)PEDESTAL, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends PylonBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction floorFacing;
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = this.defaultBlockState();
        Player player = ctx.getPlayer();
        boolean shifting = false;
        if (player != null) {
            shifting = player.isShiftKeyDown();
        }
        Section placedSection = shifting ? Section.BODY : Section.HEAD;
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        Direction placementDirection = ctx.getClickedFace().getOpposite();
        state = (BlockState)state.setValue(FACING, (Comparable)placementDirection.getOpposite());
        BlockPos floorPos = pos.relative(placementDirection);
        BlockState floorState = world.getBlockState(floorPos);
        if (floorState.getBlock() instanceof PylonBlock && (floorFacing = (Direction)floorState.getValue(FACING)).getAxis() == placementDirection.getAxis()) {
            if (floorFacing == placementDirection.getOpposite()) {
                Section floorSection = (Section)((Object)floorState.getValue(SECTION));
                BlockState newFloor = this.updatePylonBelow(world.getBlockState(floorPos.relative(placementDirection)), floorState, floorSection);
                world.setBlockAndUpdate(floorPos, newFloor);
            }
            state = (BlockState)state.setValue(SECTION, (Comparable)((Object)placedSection));
            return state;
        }
        if (floorState.isFaceSturdy((BlockGetter)world, floorPos, placementDirection.getOpposite(), SupportType.CENTER)) {
            state = (BlockState)((BlockState)state.setValue((Property)PEDESTAL, (Comparable)Boolean.valueOf(!shifting))).setValue(SECTION, (Comparable)((Object)placedSection));
        }
        return state;
    }

    public Section shiftSection(Section section) {
        return switch (section.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> Section.HEAD;
            case 2 -> Section.BODY;
            case 3 -> Section.WAIST;
        };
    }

    public BlockState updatePylonBelow(BlockState floor, BlockState pylon, Section oldSection) {
        boolean base = !(floor.getBlock() instanceof PylonBlock);
        Section checkedSection = base ? oldSection : (Section)((Object)floor.getValue(SECTION));
        Section newSection = switch (checkedSection.ordinal()) {
            case 0 -> Section.FOOT;
            case 1 -> Section.BODY;
            default -> base ? oldSection : this.shiftSection(checkedSection);
        };
        return (BlockState)pylon.setValue(SECTION, (Comparable)((Object)newSection));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SECTION, PEDESTAL, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(FACING, (Comparable)mirror.mirror((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue(FACING);
        VoxelShape shape = PYLON_SHAPES.get(facing.getAxis());
        if (((Boolean)state.getValue((Property)PEDESTAL)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)PEDESTAL_SHAPES.get(facing));
        }
        return shape;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    static {
        ImmutableMap.Builder pylonBuilder = ImmutableMap.builder();
        pylonBuilder.put((Object)Direction.Axis.X, (Object)Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        pylonBuilder.put((Object)Direction.Axis.Y, (Object)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        pylonBuilder.put((Object)Direction.Axis.Z, (Object)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
        PYLON_SHAPES = pylonBuilder.build();
        ImmutableMap.Builder pedestalBuilder = ImmutableMap.builder();
        pedestalBuilder.put((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
        pedestalBuilder.put((Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
        pedestalBuilder.put((Object)Direction.WEST, (Object)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        pedestalBuilder.put((Object)Direction.EAST, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
        pedestalBuilder.put((Object)Direction.UP, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        pedestalBuilder.put((Object)Direction.DOWN, (Object)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        PEDESTAL_SHAPES = pedestalBuilder.build();
    }

    public static enum Section implements StringRepresentable
    {
        HEAD("head"),
        BODY("body"),
        WAIST("waist"),
        FOOT("foot");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

