/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ShimmerstoneBlock
extends Block {
    public static final MapCodec<ShimmerstoneBlock> CODEC = ShimmerstoneBlock.simpleCodec(ShimmerstoneBlock::new);

    public ShimmerstoneBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends ShimmerstoneBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextBoolean()) {
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN) continue;
                BlockPos blockPos = pos.relative(direction);
                BlockState blockState = world.getBlockState(blockPos);
                if (state.canOcclude() && blockState.isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite())) continue;
                double d = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.6;
                double e = direction.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepY() * 0.6;
                double f = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.6;
                world.addParticle((ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, (double)pos.getX() + d, (double)pos.getY() + e, (double)pos.getZ() + f, 0.0, 0.05, 0.0);
            }
        }
    }
}

