/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import earth.terrarium.pastel.items.magic_items.RadianceStaffItem;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class WandLightBlock
extends LightBlock {
    public WandLightBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityShapeContext;
        if (context instanceof EntityCollisionContext && (entityShapeContext = (EntityCollisionContext)context).getEntity() != null && this.holdsRadianceStaff(entityShapeContext.getEntity())) {
            return Shapes.block();
        }
        return Shapes.empty();
    }

    private boolean holdsRadianceStaff(@NotNull Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (ItemStack stack : livingEntity.getHandSlots()) {
                if (!(stack.getItem() instanceof RadianceStaffItem)) continue;
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean holdsRadianceStaffClient() {
        return this.holdsRadianceStaff((Entity)Minecraft.getInstance().player);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (world.isClientSide && this.holdsRadianceStaffClient()) {
            world.addAlwaysVisibleParticle((ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE_SMALL, (double)pos.getX() + 0.2 + (double)random.nextFloat() * 0.6, (double)pos.getY() + 0.1 + (double)random.nextFloat() * 0.6, (double)pos.getZ() + 0.2 + (double)random.nextFloat() * 0.6, 0.0, 0.03, 0.0);
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)PastelItems.RADIANCE_STAFF.get());
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockState newState = (BlockState)state.cycle((Property)LEVEL);
            if ((Integer)newState.getValue((Property)LEVEL) == 0) {
                newState = (BlockState)newState.cycle((Property)LEVEL);
            }
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PastelSounds.RADIANCE_STAFF_PLACE, SoundSource.PLAYERS, 1.0f, (float)(0.75 + 0.05 * (double)((Integer)newState.getValue((Property)LEVEL)).intValue()));
            world.setBlock(pos, newState, 2);
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, player.getItemInHand(player.getUsedItemHand()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }
}

