/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.block.MoonstoneStrikeableBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DragonboneBlock
extends RotatedPillarBlock
implements MoonstoneStrikeableBlock {
    public static final MapCodec<DragonboneBlock> CODEC = DragonboneBlock.simpleCodec(DragonboneBlock::new);

    public DragonboneBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends DragonboneBlock> codec() {
        return CODEC;
    }

    @Override
    public void onMoonstoneStrike(Level world, BlockPos pos, @Nullable LivingEntity striker) {
        this.crack(world, pos);
    }

    public void crack(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof DragonboneBlock) {
            world.setBlockAndUpdate(pos, (BlockState)((Block)PastelBlocks.CRACKED_DRAGONBONE.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))));
            if (world.isClientSide) {
                world.playSound(null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 1.0f, Mth.randomBetween((RandomSource)world.random, (float)0.8f, (float)1.2f));
            }
        }
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    protected void onExplosionHit(BlockState state, Level world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        if (state.getBlock() instanceof RotatedPillarBlock) {
            world.setBlockAndUpdate(pos, (BlockState)((Block)PastelBlocks.CRACKED_DRAGONBONE.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))));
        }
    }
}

