/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.decoration.PastelFacingBlock;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PyriteRipperBlock
extends PastelFacingBlock {
    public static final MapCodec<PyriteRipperBlock> CODEC = PyriteRipperBlock.simpleCodec(PyriteRipperBlock::new);
    public static final BooleanProperty MIRRORED = BooleanProperty.create((String)"mirrored");
    public static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.UP, Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0));
            this.put(Direction.DOWN, Block.box((double)0.0, (double)10.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0));
            this.put(Direction.NORTH, Block.box((double)0.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0, (double)16.0));
            this.put(Direction.SOUTH, Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)6.0));
            this.put(Direction.EAST, Block.box((double)0.0, (double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)16.0));
            this.put(Direction.WEST, Block.box((double)10.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0));
        }
    };
    public static final Map<Direction, VoxelShape> SHAPES_MIRRORED = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.UP, Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)16.0));
            this.put(Direction.DOWN, Block.box((double)5.0, (double)10.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0));
            this.put(Direction.NORTH, Block.box((double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)16.0, (double)16.0));
            this.put(Direction.SOUTH, Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0));
            this.put(Direction.EAST, Block.box((double)0.0, (double)0.0, (double)5.0, (double)6.0, (double)16.0, (double)11.0));
            this.put(Direction.WEST, Block.box((double)10.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0));
        }
    };

    public PyriteRipperBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)).setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends PyriteRipperBlock> codec() {
        return CODEC;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MIRRORED});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction targetDirection = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos targetPos = pos.relative(targetDirection);
        return world.getBlockState(targetPos).isFaceSturdy((BlockGetter)world, targetPos, targetDirection, SupportType.FULL);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace();
        BlockState placedOnState = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(direction.getOpposite()));
        if (placedOnState.is((Block)this)) {
            return placedOnState;
        }
        if (ctx.getHorizontalDirection().getAxis().isHorizontal()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(ctx.getHorizontalDirection().getStepX() != 0));
        }
        boolean mirrored = ctx.getNearestLookingDirection().getAxis().isVertical();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(mirrored));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)MIRRORED) != false ? SHAPES_MIRRORED.get(state.getValue((Property)FACING)) : SHAPES.get(state.getValue((Property)FACING));
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!(!(entity instanceof LivingEntity) || entity.getType().is(PastelEntityTypeTags.POKING_DAMAGE_IMMUNE) || world.isClientSide || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
            double difX = Math.abs(entity.getX() - entity.xOld);
            double difZ = Math.abs(entity.getZ() - entity.zOld);
            if (difX >= 0.003 || difZ >= 0.003) {
                entity.hurt(PastelDamageTypes.ripping(world), 2.0f);
            }
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_OTHER;
    }
}

