/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.deeper_down.flora.WeepingGalaFrondsBlock;
import earth.terrarium.pastel.helpers.level.BlockReference;
import earth.terrarium.pastel.registries.PastelLootTables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WeepingGalaFrondsTipBlock
extends WeepingGalaFrondsBlock {
    public static final MapCodec<WeepingGalaFrondsTipBlock> CODEC = WeepingGalaFrondsTipBlock.simpleCodec(WeepingGalaFrondsTipBlock::new);
    public static final EnumProperty<Form> FORM = EnumProperty.create((String)"form", Form.class);

    public WeepingGalaFrondsTipBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FORM, (Comparable)((Object)Form.TIP)));
    }

    public MapCodec<? extends WeepingGalaFrondsTipBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue(FORM) != Form.TIP;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.1f) {
            BlockReference reference = BlockReference.of(state, pos);
            Form form = reference.getProperty(FORM);
            if (form == Form.SPRIG) {
                reference.setProperty(FORM, Form.RESIN);
                reference.update((LevelAccessor)world);
            } else {
                for (ItemStack rareStack : WeepingGalaFrondsTipBlock.getResinStacks(state, world, pos, ItemStack.EMPTY, PastelLootTables.WEEPING_GALA_SPRIG_RESIN)) {
                    WeepingGalaFrondsTipBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)rareStack);
                }
                world.playSound(null, pos, SoundEvents.BEEHIVE_DRIP, SoundSource.BLOCKS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
                reference.setProperty(FORM, Form.SPRIG);
                reference.update((LevelAccessor)world);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockReference reference = BlockReference.of(state, pos);
        if (reference.getProperty(FORM) == Form.RESIN) {
            if (!world.isClientSide()) {
                for (ItemStack rareStack : WeepingGalaFrondsTipBlock.getResinStacks(state, (ServerLevel)world, pos, player.getMainHandItem(), PastelLootTables.WEEPING_GALA_SPRIG_RESIN)) {
                    WeepingGalaFrondsTipBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)rareStack);
                }
            }
            world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 0.9f + world.getRandom().nextFloat() * 0.2f);
            reference.setProperty(FORM, Form.SPRIG);
            reference.update((LevelAccessor)world);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public static List<ItemStack> getResinStacks(BlockState state, ServerLevel world, BlockPos pos, ItemStack stack, ResourceKey<LootTable> lootTableKey) {
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)stack);
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(lootTableKey);
        return lootTable.getRandomItems(builder.create(LootContextParamSets.BLOCK));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FORM});
    }

    public static enum Form implements StringRepresentable
    {
        TIP("tip", 0),
        SPRIG("sprig", 11),
        RESIN("resin", 12);

        private final String name;
        private final int luminance;

        private Form(String name, int luminance) {
            this.name = name;
            this.luminance = luminance;
        }

        public int getLuminance() {
            return this.luminance;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

