/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelConfiguredFeatures;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SnappingIvyBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<SnappingIvyBlock> CODEC = SnappingIvyBlock.simpleCodec(SnappingIvyBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty SNAPPED = BooleanProperty.create((String)"snapped");
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final Vec3 MOVEMENT_SLOWDOWN_VECTOR = new Vec3(0.5, 0.75, 0.5);

    public SnappingIvyBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends SnappingIvyBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, SNAPPED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(PastelBlockTags.SNAPPING_IVY_PLANTABLE);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        ((ConfiguredFeature)world.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).get(PastelConfiguredFeatures.SNAPPING_IVY_PATCH)).place((WorldGenLevel)world, world.getChunkSource().getGenerator(), random, pos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(AXIS, (Comparable)(state.getValue(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)ctx.getHorizontalDirection().getAxis());
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)SNAPPED);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)SNAPPED)).booleanValue()) {
            SnappingIvyBlock.snap(state, (Level)world, pos, false);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        boolean snapped = (Boolean)state.getValue((Property)SNAPPED);
        if (!snapped && entity instanceof ItemEntity) {
            SnappingIvyBlock.snap(state, world, pos, true);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getType() != EntityType.FOX && entity.getType() != EntityType.BEE) {
                entity.makeStuckInBlock(state, MOVEMENT_SLOWDOWN_VECTOR);
                if (!snapped) {
                    entity.hurt(PastelDamageTypes.snappingIvy(world), 5.0f);
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1));
                    SnappingIvyBlock.snap(state, world, pos, true);
                }
            }
        }
    }

    private static void snap(BlockState state, Level world, BlockPos pos, boolean close) {
        BlockState newState = (BlockState)state.setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(close));
        world.setBlock(pos, newState, 2);
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        world.playSound(null, pos, close ? SoundEvents.BIG_DRIPLEAF_TILT_DOWN : SoundEvents.BIG_DRIPLEAF_TILT_UP, SoundSource.BLOCKS, 1.0f, Mth.randomBetween((RandomSource)world.random, (float)0.8f, (float)1.2f));
    }
}

