/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.interaction.NaturesStaffTriggered;
import earth.terrarium.pastel.blocks.deeper_down.flora.Dragonjag;
import earth.terrarium.pastel.blocks.deeper_down.flora.SmallDragonjagBlock;
import earth.terrarium.pastel.registries.PastelConfiguredFeatures;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallDragonjagBlock
extends DoublePlantBlock
implements Dragonjag,
BonemealableBlock,
NaturesStaffTriggered {
    public static final MapCodec<TallDragonjagBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TallDragonjagBlock.propertiesCodec(), (App)Dragonjag.Variant.CODEC.fieldOf("variant").forGetter(TallDragonjagBlock::getVariant)).apply((Applicative)i, TallDragonjagBlock::new));
    protected static final VoxelShape SHAPE_UPPER = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    protected static final VoxelShape SHAPE_UPPER_DEAD = Block.box((double)2.0, (double)0.0, (double)2.0, (double)10.0, (double)3.0, (double)14.0);
    protected static final VoxelShape SHAPE_LOWER = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty DEAD = BooleanProperty.create((String)"dead");
    protected static final Map<Dragonjag.Variant, TallDragonjagBlock> VARIANTS = new HashMap<Dragonjag.Variant, TallDragonjagBlock>();
    protected final Dragonjag.Variant variant;

    public TallDragonjagBlock(BlockBehaviour.Properties settings, Dragonjag.Variant variant) {
        super(settings);
        this.variant = variant;
        VARIANTS.put(variant, this);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)DEAD, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends TallDragonjagBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return (Boolean)state.getValue((Property)DEAD) != false ? SHAPE_UPPER_DEAD : SHAPE_UPPER;
        }
        return SHAPE_LOWER;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return Dragonjag.canPlantOnTop(floor, world, pos);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return SmallDragonjagBlock.getBlockForVariant(this.variant).getCloneItemStack(world, pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, DEAD});
    }

    @Override
    public Dragonjag.Variant getVariant() {
        return this.variant;
    }

    public static TallDragonjagBlock getBlockForVariant(Dragonjag.Variant variant) {
        return VARIANTS.get((Object)variant);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)DEAD) == false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)DEAD) == false;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        boolean success = ((ConfiguredFeature)world.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).get(PastelConfiguredFeatures.DRAGONJAGS.get((Object)this.variant))).place((WorldGenLevel)world, world.getChunkSource().getGenerator(), random, pos);
        if (success) {
            this.setDead((Level)world, pos, state, true);
        }
    }

    private void setDead(Level world, BlockPos pos, BlockState state, boolean dead) {
        BlockState posState = world.getBlockState(pos);
        if (posState.is((Block)this)) {
            world.setBlockAndUpdate(pos, (BlockState)posState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(dead)));
        }
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            posState = world.getBlockState(pos.above());
            if (posState.is((Block)this)) {
                world.setBlockAndUpdate(pos.above(), (BlockState)posState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(dead)));
            }
        } else {
            posState = world.getBlockState(pos.below());
            if (posState.is((Block)this)) {
                world.setBlockAndUpdate(pos.below(), (BlockState)posState.setValue((Property)DEAD, (Comparable)Boolean.valueOf(dead)));
            }
        }
    }

    @Override
    public boolean canUseNaturesStaff(Level world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)DEAD);
    }

    @Override
    public boolean onNaturesStaffUse(Level world, BlockPos pos, BlockState state, Player player) {
        this.setDead(world, pos, state, false);
        return true;
    }
}

