/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.groundcover;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlockTags;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlackslagBlock
extends RotatedPillarBlock
implements BonemealableBlock {
    public static final MapCodec<BlackslagBlock> CODEC = BlackslagBlock.simpleCodec(BlackslagBlock::new);

    public BlackslagBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends BlackslagBlock> codec() {
        return CODEC;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        if (!world.getBlockState(pos.above()).propagatesSkylightDown((BlockGetter)world, pos)) {
            return false;
        }
        for (BlockPos currPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState currState = world.getBlockState(currPos);
            if (!currState.is(PastelBlockTags.SPREADS_TO_BLACKSLAG)) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        ArrayList<BlockState> nextStates = new ArrayList<BlockState>();
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState blockState = world.getBlockState(blockPos);
            if (!blockState.is(PastelBlockTags.SPREADS_TO_BLACKSLAG)) continue;
            nextStates.add(blockState);
        }
        if (nextStates.isEmpty()) {
            return;
        }
        Collections.shuffle(nextStates);
        world.setBlock(pos, (BlockState)nextStates.getFirst(), 3);
    }
}

